/***************************************************************************
                          ctiffhandler.h  -  description
                             -------------------
    begin                : Thu Aug 29 2002
    copyright            : (C) 2002-2006 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTIFFHANDLER_H
#define CTIFFHANDLER_H

#include <qobject.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qptrlist.h>
#include <stdarg.h>

class QLabel;
class CPrinter;

typedef struct tiff TIFF;

// class for caching
class CImageObject {
friend class CTIFFHandler;
public:
  CImageObject(QImage image, float xres, float yres)
  : zoom(1.0), degrees(0.0), smoothScale(false), xres(xres), yres(yres) { this->image = image; }
  ~CImageObject() {}
  void rotate(float degrees, bool absolute = false);
  void scale(float zoom, bool smoothScale);
  QPixmap getPixmap() const { return pixmap; }
  QImage getImage() const { return image; }
  int realHeight();
  bool save(const QString &filename, const QString &format);
  bool save(const QString &filename, const QString &format, float zoom, bool smoothScale);
private:
  QImage image;
  QPixmap pixmap;
  float zoom;
  float degrees;
  bool smoothScale;
  float xres, yres;
};

class CTIFFHandler : public QObject {
Q_OBJECT
friend class CPrinter;
friend class CExport;
public:
  CTIFFHandler(QLabel *status, QWidget *parent=0, const char *name=0);
  ~CTIFFHandler();
  int load(const QString &fileName, float zoom = 1.0);
  void close();
  void setSmoothScale(bool activate);
  bool smoothScale();
  void setPage(int page);
  void scale(float zoomFactor);
  void rotate(double degrees);
  int page() { return _page; }
  int pages() { return _pages; }
  float zoom() { return _zoom; }
  QString sender() { return _sender; }
  QString cidName() { return _cidName; }
  QString cidNumber() { return _cidNumber; }
  QString time() { return _time; }
  const QString &filename() const { return _filename; }
  QPixmap currentPage() const { return _currentPage; }
  bool save(const QString &prefix, const QString &format, bool scaled);
  QImage image(int page);
  int currentImageRealHeight() { return buffer.at(_page - 1)->realHeight(); }
  TIFF *handler() const { return tif; }
signals:
  void update();
private:
  void error(const char *strerr, const char *reason);
  static void errorHandler(const char *module, const char* fmt, va_list ap);
  int getPage();
  void beginProcessing(const QString &textForStatus);
  void doneProcessing();
  int _page, _pages;
  QString _sender, _cidName, _cidNumber, _time;
  float _zoom;
  bool _smoothScale;
  QPtrList<CImageObject> buffer;
  QPixmap _currentPage;
  QString _filename;
  QLabel *status;
  QString lastTextForStatus;
  float xResolution;
  TIFF *tif;
};

#endif
