/***************************************************************************
                          czoomcombobox.cpp  -  description
                             -------------------
    begin                : Sat 10 Apr 2005
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qaction.h>
#include <qlineedit.h>
#include <qvalidator.h>
#include <qtooltip.h>

#include "czoomcombobox.h"

CZoomComboBox::CZoomComboBox(QWidget *parent)
: QComboBox(true, parent, "CZoomComboBox"), zoomInAction(NULL), zoomOutAction(NULL)
{
  insertItem("10%");
  insertItem("25%");
  insertItem("50%");
  insertItem("75%");
  insertItem("100%");
  setInsertionPolicy(NoInsertion);
  QToolTip::add(this, tr("Zoom"));
  QValidator *validator = new QIntValidator(1, 100, this);
  setValidator(validator);

  connect(this, SIGNAL(activated(const QString &)), this, SLOT(activate(const QString &)));
}


float CZoomComboBox::value() const
{
  QString s = currentText();
  return s.remove('%').toInt() / 100.;
}


void CZoomComboBox::setValue(float zoom)
{
  activate(QString::number(int(zoom * 100)));
}


void CZoomComboBox::activate(const QString &string)
{
  // cleanup
  QString s = string;
  s.remove('%');
  int v = s.toInt();
  if(v <= 0) v = 1;

  zoomInAction->setEnabled(v < 100);
  zoomOutAction->setEnabled(v > 10);

  setCurrentText(QString::number(v) + '%');
  lineEdit()->selectAll();
  emit zoomChanged(value());
}


void CZoomComboBox::zoomIn()
{
  QString s = currentText();
  int value = s.remove('%').toInt();

  int idx;
  for(idx = 0; idx < count() - 1; idx++)
    if(value < text(idx).remove('%').toInt())
      break;
  setCurrentItem(idx);

  activate(currentText());
}


void CZoomComboBox::zoomOut()
{
  QString s = currentText();
  int value = s.remove('%').toInt();

  int idx;
  for(idx = count() - 1; idx >= 0; idx--)
    if(value > text(idx).remove('%').toInt())
      break;
  setCurrentItem(idx);

  activate(currentText());
}
