/***************************************************************************
                          czoomcombobox.h  -  description
                             -------------------
    begin                : Sat 10 Apr 2005
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CZOOMCOMBOBOX_H
#define CZOOMCOMBOBOX_H

#include <qcombobox.h>

class QAction;

class CZoomComboBox : public QComboBox {
Q_OBJECT
public:
  CZoomComboBox(QWidget *parent);
  void setZoomInAction(QAction *action) { zoomInAction = action; }
  void setZoomOutAction(QAction *action) { zoomOutAction = action; }
  void setValue(float zoom);
  float value() const;
signals:
  void zoomChanged(float zoom);
public slots:
  void zoomIn();
  void zoomOut();
private slots:
  void activate(const QString &string);
private:
  QAction *zoomInAction, *zoomOutAction;
};

#endif
