/***************************************************************************
                          help.ui.h  -  description
                             -------------------
    begin                : Fri Aug 30 2002
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "../config.h"
#include <qfile.h>
#include <qtextstream.h>

QString uiHelp::readFile(const char *filename)
{
    QString s, fn;
    fn = QString(DOCDIR) + filename;
    QFile f(fn);
    if(f.open(IO_ReadOnly))
      {
	QTextStream t(&f);
        return t.read();
      }
    qWarning(tr("Error opening %s"), fn.latin1());
    return "";
}

void uiHelp::init()
{
  readme->setText(readFile("README"));
  changelog->setText(readFile("ChangeLog"));
  copying->setText(readFile("COPYING"));
}
