/***************************************************************************
                          interface.ui.h  -  description
                             -------------------
    reworked             : Sat 9 Apr 2005
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlabel.h>

#include "cfileslistview.h"
#include "cmainwindow.h"

void uiInterface::init()
{
  CMainWindow *mw = (CMainWindow*)parent();

  flSender->setChecked(mw->filesListView->isShownSender());
  flCidName->setChecked(mw->filesListView->isShownCidName());
  flCidNumber->setChecked(mw->filesListView->isShownCidNumber());
  flTime->setChecked(mw->filesListView->isShownTime());
  flSize->setChecked(mw->filesListView->isShownSize());
  sbSender->setChecked(::sender->isShown());
  sbCidName->setChecked(::cidName->isShown());
  sbCidNumber->setChecked(::cidNumber->isShown());
  sbTime->setChecked(mw->time->isShown());
  sbResolution->setChecked(::resolution->isShown());
  sbPages->setChecked(mw->page->isShown());
  sbFile->setChecked(mw->tbFile->isShown());
  sbView->setChecked(mw->tbView->isShown());
  sbImage->setChecked(mw->tbImage->isShown());
  sbToolBarHideFullScr->setChecked(mw->sbToolBarHideFullScr);
  sbToolBarBigPix->setChecked(mw->usesBigPixmaps());
  setFixedSize(size());
}


void uiInterface::slotApply()
{
  CMainWindow *mw = (CMainWindow*)parent();

  mw->filesListView->applyColumnsOptions(
    flSender->isChecked(),
    flCidName->isChecked(),
    flCidNumber->isChecked(),
    flTime->isChecked(), 
    flSize->isChecked());

  ::sender->setShown(sbSender->isChecked());
  ::cidName->setShown(sbCidName->isChecked());
  ::cidNumber->setShown(sbCidNumber->isChecked());
  mw->time->setShown(sbTime->isChecked());
  ::resolution->setShown(sbResolution->isChecked());
  mw->page->setShown(sbPages->isChecked());

  mw->tbFile->setShown(sbFile->isChecked());
  mw->tbView->setShown(sbView->isChecked());
  mw->tbImage->setShown(sbImage->isChecked());
  mw->setUsesBigPixmaps(sbToolBarBigPix->isChecked());
  mw->sbToolBarHideFullScr = sbToolBarHideFullScr->isChecked();
}


void uiInterface::slotOk()
{
  slotApply();
  accept();
}
