/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : 27.08.2002
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qapplication.h>
#include <qfileinfo.h>
#include <stdlib.h>
#include <signal.h>
#include "cmainwindow.h"
#include "../config.h"

const char *app = "QFaxReader";
const char *ver = VERSION;
const char *author = "Serghei Amelian";
const char *email = "serghei.amelian@gmail.com";


int main(int argc, char **argv)
{
  // ignore "broken pipe" signal
  signal(SIGPIPE, SIG_IGN);

  QString fileName;
  if(argc > 1)
      {
        QFileInfo arg(QString::fromUtf8(argv[1]));
        if(QString(argv[1]) == "--i18n")
          {
            puts(DOCDIR "i18n");
            return 0;
          }
        else if(QString(argv[1]) == "--help")
          {
            puts("Usage: " + QString(argv[0]) + " [--help | --i18n | filename]");
            return 0;
          }
        else
          fileName = arg.absFilePath();
      }

  QApplication a(argc,argv);

  CMainWindow *mw = new CMainWindow();
  mw->setCaption(app);
  a.setMainWidget(mw);

  if(argc > 1)
    mw->open(fileName);

  return a.exec();
}
