/***************************************************************************
                          qfrasciiencoder.cpp
                         ----------------------------
     begin                : 2005-06-23
     copyright            : (C) 2005 by Serghei Amelian
     email                : serghei.amelian@gmail.com
 ***************************************************************************/

#include "qfrasciiencoder.h"

const char *sHex = "0123456789abcdef";

QfrAsciiHexEncoder::QfrAsciiHexEncoder(FILE *f)
: QfrAsciiEncoder(f)
{
}


bool QfrAsciiHexEncoder::begin()
{
  pos = 0;
  return true;
}


bool QfrAsciiHexEncoder::encode(const unsigned char *buf, int len)
{
  for(int i =0; i < len; i++, buf++)
    {
      register unsigned char c = *buf;

      PUTC(sHex[(c >> 4) & 0x0f]);
      if(++pos >= width) { pos = 0; PUTC('\n'); }

      PUTC(sHex[c & 0x0f]);
      if(++pos >= width) { pos = 0; PUTC('\n'); }
    }

  return true;
}


bool QfrAsciiHexEncoder::put(unsigned char ch)
{
  unsigned char buf[2];
  buf[0] = ch;
  return encode(buf, 1);
}


bool QfrAsciiHexEncoder::end()
{
  if(pos) PUTC('\n');
  return true;
}



QfrAscii85Encoder::QfrAscii85Encoder(FILE *f)
: QfrAsciiEncoder(f), tuple(0), count(0)
{
}


bool QfrAscii85Encoder::begin()
{
  pos = 0;
  tuple = count = 0;
  return true;
}


bool QfrAscii85Encoder::encode(const unsigned char *buf, int len)
{
  for(; len; len--, buf++)
    {
      unsigned char c = *buf;
      switch(count++)
        {
          case 0: tuple |= (c << 24); break;
          case 1: tuple |= (c << 16); break;
          case 2: tuple |= (c <<  8); break;
          case 3: tuple |= c;
                  if(tuple == 0)
                    {
                      PUTC('z');
                      if(pos++ >= width)
                        {
                          pos = 0;
                          PUTC('\n');
                        }
                    }
                  else
                    encodeTuple(tuple);
                  tuple = 0;
                  count = 0;
                  break;
        }
    }

  return true;
}


bool QfrAscii85Encoder::put(unsigned char ch)
{
  unsigned char buf[2];
  buf[0] = ch;
  return encode(buf, 1);
}


bool QfrAscii85Encoder::end()
{
  if(count > 0)
    encodeTuple(tuple);
  if(pos + 2 > width)
    PUTC('\n');
  PUTS("~>\n");
  return true;
}


bool QfrAscii85Encoder::encodeTuple(unsigned long tuple)
{
  char buf[5], *p = buf;

  for(int i = 0; i < 5; i++, p++)
    {
      *p = tuple % 85;
      tuple /= 85;
    }

  for(int i = 0; i <= count; i++)
    {
      PUTC(*--p + '!');
      if(pos++ >= width)
        {
          pos = 0;
          PUTC('\n');
        }
    }

  return true;
}

