/***************************************************************************
                          qfrasciiencoder.h
                         ----------------------------
     begin                : 2005-06-23
     copyright            : (C) 2005 by Serghei Amelian
     email                : serghei.amelian@gmail.com
 ***************************************************************************/
#ifndef _QFRASCIIENCODER_H_
#define _QFRASCIIENCODER_H_

#include <stdio.h>

#define PUTC(a) { putc(a, f); if(ferror(f)) return false; }
#define PUTS(a) { fputs(a, f); if(ferror(f)) return false; }

class QfrAsciiEncoder {
public:
  QfrAsciiEncoder(FILE *f) : f(f), pos(0), width(74) {}
  virtual bool begin() = 0;
  virtual bool encode(const unsigned char *buf, int len) = 0;
  virtual bool end() = 0;

protected:
  FILE *f;
  int pos, width;
};


class QfrAsciiHexEncoder : public QfrAsciiEncoder {
public:
  QfrAsciiHexEncoder(FILE *f = stdout);
  bool begin();
  bool encode(const unsigned char *buf, int len);
  bool put(unsigned char ch);
  bool end();
};


class QfrAscii85Encoder : public QfrAsciiEncoder {
public:
  QfrAscii85Encoder(FILE *f = stdout);
  bool begin();
  bool encode(const unsigned char *buf, int len);
  bool put(unsigned char ch);
  bool end();

protected:
  bool encodeTuple(unsigned long tuple);

private:
  unsigned tuple;
  int count;
};

#endif // _QFRASCIIENCODER_H_
