/***************************************************************************
                          qfrpostscript.h
                         ----------------------------
     begin                : 2005-06-23
     copyright            : (C) 2005 by Serghei Amelian
     email                : serghei.amelian@gmail.com
 ***************************************************************************/
#ifndef _QFRPOSTSCRIPT_H_
#define _QFRPOSTSCRIPT_H_

#include "qfrasciiencoder.h"

class QfrTiffIO;

class QfrPostscript {
public:
  QfrPostscript(FILE *f);
  ~QfrPostscript();
  bool beginDocument(const char *title, int pagesPerSheet, int width, int height, int top, int bottom, int left, int right, int level, bool border);
  bool endDocument();
  bool pushImage(QfrTiffIO &tif);

  int availWidth() const;
  int availHeight() const;

protected:
  bool newPage();
  bool drawRectangle(int x, int y, int w, int h);

  bool drawLevel1Image(int x, int y, int w, int h, QfrTiffIO &tif);
  bool drawLevel1BWImage(int x, int y, int w, int h, int iw, int ih, int bits, bool minIsWhite, QfrTiffIO &tif);
  bool drawLevel1ColorImage(int x, int y, int w, int h, int iw, int ih, QfrTiffIO &tif);

  bool drawLevel2Image(int x, int y, int w, int h, QfrTiffIO &tif);
  QString level2ColorSpace(QfrTiffIO &tif);
  QString level2ImageDict(QfrTiffIO &tif, int w, int h);

private:
  FILE *f;
  int pages, images, m_pagesPerSheet, spacing;
  int m_width, m_height, m_top, m_bottom, m_left, m_right;
  int m_level;
  bool m_landscape, m_border;

  bool useImagemask;
  bool ascii85;
  bool interpolate;
  bool level3;
  bool use_rawdata;
  int alpha;
};

#endif // _QFRPOSTSCRIPT_H_
