/***************************************************************************
                          qfrspinbox.cpp  -  description
                             -------------------
    begin                : Thu Jun 30 2005
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei@thel.ro
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <math.h>
#include <qvalidator.h>

#include "qfrspinbox.h"

QfrSpinBox::QfrSpinBox(QWidget *parent, const char *name)
: QSpinBox(0, 100, 1, parent, name)
{
  QDoubleValidator *validator = new QDoubleValidator(this);
  validator->setDecimals(1);
  setValidator(validator);
}


QString QfrSpinBox::mapValueToText(int value)
{
  return QString("%1.%2").arg(value / 10).arg(value % 10);
}


int QfrSpinBox::mapTextToValue(bool *ok)
{
   return (int)round(10. * text().toFloat());
}
