/***************************************************************************
 *   Copyright (C) 2002-2005 by Serghei Amelian                            *
 *   serghei.amelian@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <stdarg.h>

#include "qfrtiffio.h"

/** return tag value in current directory */
int QfrTiffIO::GetField(ttag_t tag, ...)
{
  va_list ap;

  va_start(ap, tag);
  int status = VGetField(tag, ap);
  va_end(ap);
  
  return status;
}


/** return tag value in current directory*/
int QfrTiffIO::GetFieldDefaulted(ttag_t tag, ...)
{
  va_list ap;

  va_start(ap, tag);
  int status =  VGetFieldDefaulted(tag, ap);
  va_end(ap);
  
  return status;
}


/** Record the value of a field in the
 internal directory structure.  The
 field will be written to the file
 when/if the directory structure is
 updated. */
int QfrTiffIO::SetField(ttag_t tag, ...)
{
  va_list ap;

  va_start(ap, tag);
  int status = VSetField(tag, ap);
  va_end(ap);
  
  return status;
}
