/***************************************************************************
 *   Copyright (C) 2002-2005 by Serghei Amelian                            *
 *   serghei.amelian@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QFRVIEWER_H
#define QFRVIEWER_H

#include <qbitmap.h>
#include <qcursor.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qscrollview.h>
#include <qtimer.h>

class QPopupMenu;

class QfrCanvas : public QWidget {
Q_OBJECT
friend class QfrViewer;
public:
  QfrCanvas(QWidget *parent);
  void setContextMenu(QPopupMenu *popup) { m_popup = popup; }
protected:
  void paintEvent(QPaintEvent *e);
  void mousePressEvent(QMouseEvent *e);
  void mouseReleaseEvent(QMouseEvent *e);
  void mouseMoveEvent(QMouseEvent *e);
  void contextMenuEvent(QContextMenuEvent *e);
private:
  QCursor m_hand1, m_hand2;
  QPoint m_dragGrabPos;
  bool m_readyForDrag;
  QPixmap m_pixmap;
  QPopupMenu *m_popup;
};

class QfrViewer : public QScrollView {
Q_OBJECT
friend class QfrCanvas;
public:
  QfrViewer(QWidget *parent);
  ~QfrViewer();
  void setPixmap(const QPixmap &pixmap);
  QPixmap &pixmap() { return m_canvas->m_pixmap; }
  QfrCanvas *canvas() { return m_canvas; }
  void hideCanvas() { m_canvas->hide(); }
  void showCanvas() { m_canvas->show(); }
signals:
  void resized();
protected:
  void drawContents(QPainter *p, int, int, int, int);
  void resizeEvent(QResizeEvent *e);
private:
  void centerCanvas();
private slots:
  void delayedResizeEvent();
private:
  QfrCanvas *m_canvas;
  int m_canvasX, m_canvasY;
  bool m_centerCanvas;
  QTimer m_timer;
};

#endif
