#include <stdio.h>
#include <errno.h>

int main(int argc, char **argv)
{
  FILE *f;
  unsigned char file[256+1];
  int i, j, k;
  
  if(argc < 2)
    {
      fprintf(stderr, "bin2c: no input file\n");
      return 1;
    }
  
  f = fopen(argv[1], "r");
  if(!f)
    {
      fprintf(stderr, "bin2c: %s\n", strerror(errno));
      return 2;
    }
  
  snprintf(file, sizeof(file), argv[1]);
  file[256] = 0;
  
  for(i = 0; file[i]; i++)
    if(file[i] == '.')    
      file[i] = '_';
  
  printf("/* %s */\n", file);
  printf("static const unsigned char %s[] = {\n", file);
  
  fseek(f, 0L, SEEK_SET);
  for(i = 0, k = 0; !feof(f); i++)
    {
      if(i > 16)
        {
          putchar('\n');
	  i = 0;
        }
      j = fgetc(f);
      if(j >= 0)
        {
	  //printf("0x%02x,", j);
	  printf("%d,", j);
	  k++;
	}
    }
  printf(" };\n\nstatic int len_%s = %d;\n", file, k);
  
  fclose(f);
  return 0;
}
