/******************************************************************************
** 	ui.h extenion file, included from the uic-generated form implementation.
**
** 	If you wish to add, delete or rename functions or sluts use
**	 Qt Designer which will update this file, preserving your code. Create an
** 	init() function in place of a constructor, and a destroy() function in
**	 place of a destructor.
**
**	ultima revisione: 03/01/2005
**
**	Qtballit 0.1 beta - Qt ballistic calculation app - Copyright (C)  Stefano Jodice 2004  
**
**     	This program is free software; you can redistribute it and/or modify
**     	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2 of the License, or
**    	 (at your option) any later version.
** 
**    	This program is distributed in the hope that it will be useful,
**     	but WITHOUT ANY WARRANTY; without even the implied warranty of
**    	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**     	GNU General Public License for more details.
**
**     	You should have received a copy of the GNU General Public License
**     	along with this program; if not, write to the Free Software
**    	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
*********************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
// #include <unistd.h>
// #include <limits.h>
// #include <cups/cups.h>
//#include <iostream.h>

#include <qstring.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qstatusbar.h>

#include "convert.h"
#include "aboutqtb.h"
#include "frmtraiett.h"

#define QB_DATA ".qtbdata"
#define ZERO "0."


//#define QB_DATA_TAB1 ".qtbdatab1"

void risultato_penetraz(float &, float &, float &);
float energia_kgm,energia_j,peso,velocita,diametro=0;
float veliniziale,velfinale,lunghtratto,densaria,coeffaero= 0;
float (*baldata)[10];
float *balPtr=0;
float distanza_massima=0;

convert c;
float K;
int count;

void qtballit::init()
	
{
    
    About = 0;
    coeffaero_gb->setEnabled(FALSE); //<-------
    statusBar()->message(tr("Benvenuto in Qt Ballit"));
}

void qtballit::destroy()
{
    delete [] baldata;
 
}

void qtballit::algoritmo_energia()
{
    QString buf;
    
    buf= peso_le->text();
    buf.replace(",",".",FALSE);
    peso_le->setText(buf);
    
    peso = peso_le->text().toFloat();
    
    if (grani_rb->isChecked()){
	
	c.grstogrm(peso);
}
    buf= velocita_le->text();
    buf.replace(",",".",FALSE);
    velocita_le->setText(buf);
    
    velocita=velocita_le->text().toFloat();
    
    if (fsec_rb->isChecked()){
	
	c.fsectomsec(velocita);
    }
    buf= diametro_le->text();
    buf.replace(",",".",FALSE);
    diametro_le->setText(buf);
    
    diametro=diametro_le->text().toFloat();
    if (inch_rb->isChecked()){
	
	c.inchtomm(diametro);
    }
    
    if ( peso==0 || velocita == 0 || diametro==0)
	QMessageBox::critical(this,tr("Errore"),tr("riempire tutti i campi"));
    else
    {
	energia_kgm=((((peso / 1000) / 9.8) / 2) * pow(velocita,2)) ;
	energia_j=((peso * pow(velocita,2)) /2000);
    
    kgm_le->setText(QString::number(energia_kgm) );
    joules_le->setText(QString::number(energia_j));
}
    
}




void qtballit::algoritmo_penetrazione()
	
{
    
    penetraz_le->setText(QString::number(0));
    volcavita_le->setText(QString::number(0));
    vellimite_le->setText(QString::number(0));
    
    //  PENETRAZIONE  NEL LEGNO D' ABETE  
    if (abete_rb->isChecked())
    {
	if (piombo_rb->isChecked())
	penetraz_le->setText(QString::number((0.0298 * peso * pow(velocita,1.5) / pow(diametro,2) )*0.8) ) ;
	else
	penetraz_le->setText(QString::number(0.0298 * peso * pow(velocita,1.5) / pow(diametro,2) ) ) ;
	volcavita_le->setText(QString::number(0.00234 * pow(velocita,1.5)));

    }  
    // PENETRAZIONE NEL FERRO
    if (ferro_rb->isChecked())
	
	
	
	penetraz_le->setText(QString::number(.194 * (pow ((pow (( peso * pow (velocita,2) /19620),3)) / (pow (diametro,5))   , (.25))))); 
    
    
    // PENETRAZIONE NELL' OSSO
    if (osso_rb->isChecked())
	
	
    {
	float c=0;
	
	if (blindato_rb->isChecked())
	    c=0.44;
	if (piombo_rb->isChecked())
	    c=0.3;
	if (piombowc_rb->isChecked())
	    c=0.15;
penetraz_le->setText(QString::number( ( c * 10  * (peso / diametro)  * (pow(((velocita -60) / 100),  2))   ) / 10)  );  

	
    }  
    // PENETRAZIONE NEI TESSUTI MUSCOLARI
    if (tessuti_rb->isChecked())
    {
	
	float ds,vm,pu=0;
	ds = (peso / (0.0078539 * pow (diametro,2)));
	vm = 125 * (1 / ds) + 22;
	pu = 2.3 * ds * log((velocita - vm) / 50);
	penetraz_le->setText(QString::number(pu));
	vellimite_le->setText(QString::number(vm));
	
	
	
    }	
}

void qtballit::algoritmo_velresidua()
{
    
    float eg,penetrazione,er,velresidua,spessore=0;
    QString buf;
    if (velresferro_rb->isChecked())
	
    {
	
	 buf= spessferro_le->text();
	 buf.replace(",",".",FALSE);
	 spessferro_le->setText(buf);
	
	spessore=spessferro_le->text().toFloat();
	eg=(peso * pow(velocita,2) / 19620);
	penetrazione=(.194 * (pow(((pow(eg,3)) / (pow(diametro,5))),(.25))));
	er=pow(((pow(((penetrazione-spessore) / .194),4)) * pow(diametro,5)),(.333));
	velresidua= pow(((19620 * er) / peso), .5);
	
	risultato_penetraz(spessore,penetrazione,velresidua);
    }
    
    if (velreslegno_rb->isChecked())
    {
	 buf= spesslegno_le->text();
	 buf.replace(",",".",FALSE);
	 spesslegno_le->setText(buf);
	
	spessore=spesslegno_le->text().toFloat();
	penetrazione=(.0298 * peso * (pow(velocita,1.5) / (pow(diametro,2))));
	velresidua=pow((((penetrazione - spessore) * pow(diametro,2)) / (.0298 * peso)) , (1 / 1.5));
	
	risultato_penetraz(spessore,penetrazione,velresidua);
    }
}




void qtballit::risultato_penetraz( float &spess, float &penetraz, float &velres)
{
    if (penetraz > spess)
    {
	msec_le->setText(QString::number(velres));
	
	c.msectofsec(velres);
	fsec_le->setText(QString::number(velres));
    }
    else
    {
	
	char buffo[12];
	
	sprintf ( buffo, "%.2f\n", penetraz ) ;
	
	QString str =  buffo;
	str.prepend ("penetr.cm.");
	
	msec_le->setText(tr("proiettile arrestato") );
	fsec_le->setText(str);
	
	
    }
}


void qtballit::algoritmo_variazione()
{
    float percorso,pesocarica,percnuovo,velnuova,cr=0;
    QString buf;
    
             buf=velnota_le ->text();
	 buf.replace(",",".",FALSE);
	 velnota_le ->setText(buf);
	 
	 buf=percorso_le ->text();
	 buf.replace(",",".",FALSE);
	 percorso_le ->setText(buf);
	 
	 buf=pesocarica_le ->text();
	 buf.replace(",",".",FALSE);
	 pesocarica_le ->setText(buf);
	 
	 buf=percnuovo_le ->text();
	 buf.replace(",",".",FALSE);
	 percnuovo_le ->setText(buf);
	 
    
    velocita=velnota_le->text().toFloat();
    percorso=percorso_le->text().toFloat();
    pesocarica=pesocarica_le->text().toFloat();
    percnuovo=percnuovo_le->text().toFloat();
    
    if ( grani_rb->isChecked() )
    {
	convert c ;
	c.grstogrm(pesocarica) ;
    }
    if ( fsec_cb->isChecked() )
    {
	convert c ;
	c.fsectomsec(velocita) ;
    }
    
    cr = ( velocita / ( ( pow (( percorso / ( 10 * diametro )), .25 )) * ( pow (( pesocarica /  peso ) , .5 )) ) ) ;
    velnuova = pow (( percnuovo / ( 10 * diametro )), .25 ) * cr * ( pow (( pesocarica / peso) , .5 )) ;
    
    velnuova_le->setText(QString::number(velnuova));
    
}


int qtballit::algoritmo_coefficiente()
{
    float veliniziale_coeff=0;
    QString buf;
    
    buf= pesopr_le->text();
    buf.replace(",",".",FALSE);
    pesopr_le->setText(buf);
    
    peso=pesopr_le->text().toFloat();
    
    if (grs_rb->isChecked())
    {
	c.grstogrm(peso);
    }
    
    buf= diametropr_le->text();
    buf.replace(",",".",FALSE);
    diametropr_le->setText(buf);
    
    diametro=diametropr_le->text().toFloat();
    
    if (inches_rb->isChecked())
    {
	c.inchtomm(diametro);
	
    }
    
    buf= veliniz_le->text();
    buf.replace(",",".",FALSE);
    veliniz_le->setText(buf);
    
    veliniziale_coeff=veliniz_le->text().toFloat();
    
    if ( fsec2_cb->isChecked())
    {	
	c.fsectomsec(veliniziale_coeff);

    }
    
    buf= velfinale_le->text();
    buf.replace(",",".",FALSE);
    velfinale_le->setText(buf);
    
    velfinale=velfinale_le->text().toFloat();
    
    if ( fsec2_cb->isChecked())
    {	
	c.fsectomsec(velfinale);
    }
    
    buf= lunghtratto_le->text();
    buf.replace(",",".",FALSE);
    lunghtratto_le->setText(buf);
    
    lunghtratto=lunghtratto_le->text().toFloat();
    
    if ( feet_cb->isChecked())
    {
	c.fsectomsec(lunghtratto);
    }	
    
    buf= densaria_le->text();
    buf.replace(",",".",FALSE);
    densaria_le->setText(buf);
    
    densaria=densaria_le->text().toFloat();
    if  (peso==0 || diametro==0 ||  veliniziale_coeff ==0 || velfinale==0 ||  lunghtratto==0 ||  densaria==0 )
    {
	QMessageBox::critical(this,tr("Errore"),tr("riempire tutti i campi"));
	return 1;
    }
    else
    {

	
	coeffaero = ((log(veliniziale_coeff) - log(velfinale) ) / (densaria * .000392699 * pow(diametro,2) * lunghtratto / peso ));
	
	K = (pow(diametro,2) * coeffaero * densaria ) / ( peso * 2546.479);
	
	coeffaero_result_le->setText(QString::number(coeffaero));
	
	coeffk_le->setText(QString::number(K));
    }
    return 0;
}




void qtballit::helpIndex()
{
}

void qtballit::helpContents()
{
}

void qtballit::helpAbout()
{
}


void qtballit::showab()
{
    
    AboutQtB *About= new AboutQtB(this);
    if (About->exec() == QDialog::Accepted)
    {}
    delete About;
}




int qtballit::algoritmo_calcolatraiett()
{
    float distazz= 0,distmax= 0,velvlat= 0,sight_gap = 0;    
    float a=0, Yo=0, Ke=0, h1= 0, h2= 0, h3= 0, h4= 0, Y= 0, ys= 0, tm= 0, gee= 0, hyv= 0, yh= 0, yv= 0, W= 0, ve= 0, j= 0, T=0;  //
    double ye=0;
    int e= 0,i= 0, intervalli=0;
    
    peso=0;
    diametro=0;
    veliniziale=0;
  
    QString buf;
    
    buf= pesopr_le->text();
    buf.replace(",",".",FALSE);
    pesopr_le->setText(buf);
    
    peso = pesopr_le->text().toFloat();
    peso_le_2->setText(QString::number (peso));
    
         if ( ( grs_rb->isChecked()  ) )
    {
	  c.grstogrm(peso);
	}
    
    buf= diametropr_le->text();
    buf.replace(",",".",FALSE);
    diametropr_le->setText(buf);
    
    diametro = diametropr_le->text().toFloat();
    diam_le->setText(QString::number (diametro));
    
         if ( ( inches_rb->isChecked() ) )
    {
	     c.inchtomm(diametro);
	}
    
    buf= veliniz2_le->text();
    buf.replace(",",".",FALSE);
    veliniz2_le->setText(buf);
    
    veliniziale =veliniz2_le->text().toFloat();
    
         if ( ( fsec3_cb->isChecked() ) )
    {
	c.fsectomsec(veliniziale);
	}
	    
    
    buf= distazz_le->text();
    buf.replace(",",".",FALSE);
    distazz_le->setText(buf);
    
    distazz=distazz_le->text().toFloat();
    
    buf= distmax_le->text();
    buf.replace(",",".",FALSE);
    distmax_le->setText(buf);
    
    distmax=distmax_le->text().toFloat();
    
    distanza_massima = distmax;
    
    intervalli=intervalli_le->text().toInt();
    
    buf= velvlat_le->text();
    buf.replace(",",".",FALSE);
    velvlat_le->setText(buf);
    
    velvlat=velvlat_le->text().toFloat();
    ventolatera_le->setText(QString::number(velvlat));
    
    buf= sight_gap_le->text();
    buf.replace(",",".",FALSE);
    sight_gap_le->setText(buf);
    

    sight_gap=sight_gap_le->text().toFloat() ; 
    sight_gap=sight_gap / 1000;
    
    
    buf= angsito_le->text();
    buf.replace( ","  ,  "", FALSE);
    buf.replace( "."  ,  "", FALSE);
    angsito_le->setText(buf);
    
    a=angsito_le->text().toFloat();

    buf= densaria_cust_le->text();
    buf.replace(",",".",FALSE);
    densaria_cust_le->setText(buf);
    
    densaria=densaria_cust_le->text().toFloat() ;
  
    if ( pesopr_le->text().toFloat() ==0 || diametropr_le->text().toFloat()  ==0 || veliniz2_le->text().toFloat()   ==0 || densaria_cust_le->text().toFloat() ==0 || distazz  ==0 || distmax  ==0 ||  intervalli  ==0 || sight_gap ==0  )
    {
	QMessageBox::critical(this,tr("Errore"),tr("riempire tutti i campi"));
    }
    else
    {
	
	
	if (customcoeff_rb->isChecked())
	{
	    
	    buf= coeffaero_cust_le->text();
	    buf.replace(",",".",FALSE);
	    coeffaero_cust_le->setText(buf);
	    
	    coeffaero = coeffaero_cust_le->text().toFloat();
	    K = (pow(diametro,2) * coeffaero * densaria) / (peso * 2546.479);

	    
	    coeffaero_result_le->setText(QString::number(coeffaero));
	    coeffk_le->setText(QString::number(K));
	    
	}
	else
	{
	    if (algoritmo_coefficiente() ==1)
		return 1;	 
	    
	    buf= coeffk_le->text();
	    buf.replace(",",".",FALSE);
	    coeffk_le->setText(buf);
	    
	    coeffaero = coeffaero_result_le->text().toFloat();
	    
	    
	    //coeffaero_result_le->setText(QString::number(coeffaero));
	    
	    coeffk_le->setText(QString::number(K));
	}    
	coeffaero_le->setText(QString::number(coeffaero));
	
	
	h1 = 2.453 / (pow(K,2) * pow(veliniziale,2));
	h2 = (exp(2 * K *distazz )) - (2 * K *distazz ) - 1;
	Y = h1 * h2;
	
	// --- Calcolo della DOA -Distanza Ottimale di Azzeramento ---
	ys = (8 / 2) + .4 * (sight_gap * 100);
	tm = .090305 * sqrt(ys);
	gee = (1 / K) * log((veliniziale * K * tm) + 1);
	distottima_le->setText(QString::number(gee));
	
	e = 0 -intervalli ;
	
	
	FILE *data_f;
	data_f= fopen(QB_DATA, "w");
	
	
fprintf ( data_f, "%s", "\n DATI DELLA TRAIETTORIA \n\n");
fprintf ( data_f, "%s", "\n Peso del proiettile g. ");
  fprintf(data_f,"%c%c%c",9,9,9);
fprintf ( data_f, "%-3.1f\n", peso);
fprintf ( data_f, "%s", "\n Velocita del proiettile m/s ");
  fprintf(data_f,"%c%c%c",9,9,9);
fprintf ( data_f, "%-3.1f\n", veliniziale);
fprintf ( data_f, "%s", "\n Diametro del proiettile mm ");
  fprintf(data_f,"%c%c%c",9,9,9);
fprintf ( data_f, "%-3.1f\n", diametro);
fprintf ( data_f, "%s", "\n Coefficiente aerodinamico del proiettile ");
  fprintf(data_f,"%c",9);
fprintf ( data_f, "%-3.1f\n", coeffaero);
fprintf ( data_f, "%s", "\n Altezza della linea di mira sull'anima mm ");
  fprintf(data_f,"%c",9);
fprintf ( data_f, "%-3.1f\n",(sight_gap_le->text().toFloat() ));
fprintf ( data_f, "%s", "\n Densita dell'aria ");
  fprintf(data_f,"%c%c%c%c",9,9,9,9);
fprintf ( data_f, "%-3.1f\n", densaria);
fprintf ( data_f, "%s", "\n Vento laterale di m/s "); 
  fprintf(data_f,"%c%c%c%c",9,9,9,9);
fprintf ( data_f, "%-3.1f", velvlat); 
fprintf ( data_f, "%s", "\n\n");


fprintf ( data_f,  "%s","\n Dist-  Cadu-	 Ordi-     Veloci-    Ener-    Deviaz.    Tempo   Scarto    Scarto    Scarto");
fprintf ( data_f,  "%s","\n anza   ta  	 nata	   ta'res.    gia      vento      volo    mira  per angolo    tot. per errore");
fprintf ( data_f,  "%s","\n (m)    (cm)      (cm)      (m/s)      (J)      (cm)       (s)     (cm)  di sito (cm)  di prospettiva");
fprintf ( data_f,  "%s","\n------------------------------------------------------------------");
fprintf ( data_f,  "%s","-----------------------------------\n");
	
	
	int distmax2 = static_cast<int>(distmax);
	
	count=abs(distmax2/intervalli);  // <----
	
	baldata = new float [count+2] [10]; //<== + 1;
	
	balPtr= &baldata[0][0];
	
	if((distmax/intervalli)<=count )
	traiett_tbl->setNumRows(count+1); //<<== count+1
	else
	traiett_tbl->setNumRows(count+2);
	
	count=0;
	
	float TAzz;
	
	TAzz = (1 / (veliniziale * K)) * ((exp(K * distazz)) - 1);
	
	
	 float ar, arc, yy =0;
	
	for (i = 1; i <= (distmax + intervalli ); i+=intervalli)
	{
	   // std::cout<<"sto scrivendo i dati delle colonne 1-8, riga "<<count<<"."<<endl;
	    e = e +intervalli ;
	    
	    baldata[count][0]=e;
	   
	    // --- Calcolo della caduta del proiettile
	    h3 = 2.453 / (pow( K,2 ) * pow( veliniziale,2 ));
	    h4 = (exp(2 * K * e)) - (2 * K * e) - 1;
	    ye = h3 * h4;
	    
	    //baltab.setValue((ye*-100),count,1);
	    baldata [count] [1] =ye*-100;
	    
	    // --- Calcolo delle ordinate del proiettile
	    yh = e * (Y / distazz) - ye;
	    
	    //baltab.setValue((yh*100),count,2);
	     baldata [count] [2] =yh*100;
	         
	     
	    // --- Calcolo della velocita' del proiettile
	    ve = veliniziale * (exp(-K * e));
	    
	    //baltab.setValue(ve,count,3);
	    baldata [count] [3]  =ve;
	    
	    //R--- Calcolo dell'energia
	    j = ( peso  * (ve * ve)) / 2000;
	    
	    //baltab.setValue(j,count,4);
	    baldata [count] [4] =j;
	    
	    
	    // --- Calcolo del tempo di volo
	    T = (1 / ( veliniziale * K)) * ((exp(K * e)) - 1);
	    
	    //baltab.setValue(T,count,6);
	    baldata [count] [6] =T;
	    
	    
	    // --- Calcolo della deviazione per il vento
	    W = (100 * velvlat) * (T - (e / veliniziale));
	    
	    //baltab.setValue(W,count,5);
	    baldata [count] [5] =W;
	    
	    
	    // --- Calcolo delle ordinate rispetto alla linea di mira
	    hyv = (sight_gap * (distazz - e) /distazz );
	    yv = yh - hyv;
	    
	    //baltab.setValue(yv,count,7);
	    baldata [count] [7]  =yv*100;
	    
	    //----Calcolo dello scarto per tiro con grande angolo di sito
	  
	    if  ( a != 0 )	
	    {
		
	   // float ar, arc, yy, a =0;

	    ar = a * 3.1415 / 180;
	
	    arc = cos(ar);
                
		
yy=((9.91 * pow(TAzz,2)) / 2) * (e / distazz - arc * pow ((T / TAzz), 2)) - ((sight_gap / 1000) * (1 - distmax / distazz)); 

	Yo = yy * 100;						
	Ke = Yo / arc;							
                   }		                         
	
	baldata [count] [8]  =Yo;
	baldata [count] [9]  =Ke;
   
	    /*Formattazione e stampa su file*/
	    
	    char buff[30];
	    sprintf( buff, "%d", e );
	    int nchars = strlen( buff );
	    int nspaces;
	    nspaces = (6-nchars);
	    
	 
	    fprintf (data_f," %d",e);
	    int i;
	    for (i =1; i <=nspaces; i++)
	    {
		
		fprintf (data_f,"%c", (char)32);
	    }
	    
	    fprintf (data_f, " %-8.1f   ",ye * -100);
	        //baldata[count] [1] = sprintf ("%-8.1f   ",ye * -100);
	    
	    fprintf (data_f, "%-8.1f   ",yh *  100);
	      //baldata[count] [2]=sprintf ("%-8.1f   ",yh *  100);
	    
	    fprintf (data_f, "%-8.1f  ",ve);
	     //baldata[count] [3]=sprintf ("%-8.1f  ",ve);
	    
	    fprintf (data_f, "%-7.2f  ",j);
	    // baldata[count] [4]=sprintf ("%-7.2f  ",j);
	    
	    fprintf (data_f, "%-7.2f   ",W*-1);
	     //baldata[count] [5]=sprintf ("%-7.2f   ",W*-1);
	    
	    fprintf (data_f, "%-5.4f   ",T);
	     //baldata[count] [6]=sprintf ("%-5.4f   ",T);
	    
	    fprintf (data_f, "%-8.1f",yv*100);
	     //baldata[count] [7]=sprintf ("%-8.1f\n",yv);
	    
	     fprintf (data_f, "  %-8.1f",Yo);
	     
	     fprintf (data_f, "    %-8.1f\n",Ke);
	     
	    count++;	
	}
	
	fprintf(data_f, "\n La distanza ottimale di azzeramento e' di ");
	fprintf ( data_f, "%-5.1f", gee);
	fprintf ( data_f, "%s", " metri pari a ");
	fprintf ( data_f, "%-8.1f", gee / .3048);
	fprintf ( data_f, "%s", " piedi \n  ");
	fclose(data_f);
	
	QHeader *th = traiett_tbl->verticalHeader();
	
	for (int row=0; row < count; row++)
	{
	    
	   // th->setLabel( row, QString::number(baltab.getValue (row,0)  ) );
	    th->setLabel( row, QString::number(baldata [row][0])  ) ;
	    
	    for (int col=0; col < 9;col++)
	    {
		
		//traiett_tbl->setText(row,col,QString::number( baltab.getValue (row,col+1)));
		
		if (baldata [row][col+1] <0.01 && baldata [row][col+1]> -0.01 ) 
		    (baldata [row][col+1]) =0;
		traiett_tbl->setText(row,col,QString::number(baldata [row][col+1]));
		
		//valore=QString::number( baldata [row][col+1]);
		//traiett_tbl->setText(row,col,QString::number(valore.toDouble(),10));
		
	    }
	} 
	
	
	 // passa al tab 2
	
	 e0traiett_tw->setCurrentPage(2);
	 
  
    frmtraiett *traiett= new frmtraiett(this);
    traiett->show();
    }
   
    return 0;	
}

void qtballit::showText()
{
    int ret;
    char app[22];
     sprintf( app,"%s","gvim "); 
               
	    strcat(app,QB_DATA);
    ret = (system (app)) ;
 
    //printf("\nret=%d\n", ret);
    
    if (ret != 0)
	
    {
	printf ("gvim non trovato\n");
	
	sprintf( app,"%s","kedit "); 
	    
	    strcat(app,QB_DATA);
	    
	ret = (system (app)) ;
	
	
	if (ret != 0)
	{
	 
	    char postino[22];
	    sprintf( postino,"%s",(getenv("EDITOR"))); 
	    strcat(postino," ");
	    strcat(postino,QB_DATA);
	 
	    
	    ret = (system(postino));
	 
	    
	    if (ret != 0)
		
	    {
		
		QMessageBox::warning(this, tr("Qtballit"),tr("Nessun editor trovato.\n Specificare l'editor predefinito nella variabile $EDITOR\n"));
	    }
	}
    }
}

void qtballit::salvaFile()
{
    QString s = QFileDialog::getSaveFileName(
	    "chart.txt",
	    tr("testo semplice (*.txt)"),
	    this,
	    tr("Salva con nome"),
	    tr("Salva tabella") );

    if (s.isNull()==FALSE)
    {
    char copy[22];
    sprintf( copy,"%s","cp "); 
	    strcat(copy,QB_DATA);
	         strcat(copy, " ");
	           strcat(copy,s);
		
int ret;
ret=( system(copy));
 
     if (ret==0)
            {
	QMessageBox::information(this,tr("OK"),tr("File salvato"));
     statusBar()->message( QString( tr("Salvato \'%1\'") ).arg( s ), 2000 );
            }
     else
            {
            QMessageBox::critical(this,tr("Errore"),tr("Impossibile salvare il file"));
     
     statusBar()->message( QString( tr("Impossibile salvare \'%1\'") ).arg( s ), 2000 );
            }			
 }
    
}


void qtballit::chk_val_0()
{
    if (velfinale_le->text().toFloat() > veliniz_le->text().toFloat())
    {
	QMessageBox::critical(this,tr("Errore"),tr("La velocit terminale non pu essere superiore a quella iniziale\n"));
	
	velfinale_le->setText("");
    }
}


void qtballit::minimizza()
{
this->iconify() ;
}


void qtballit::massimizza()
{
this->showMaximized() ;
}


void qtballit::mostraManuale()
{
  const char command_man[]="$BROWSER ./qtballit_man.htm";
    
system(command_man);
}


void qtballit::mostraTabella()
{
  const char command_tab[]="$BROWSER ./qtballit_tabella.htm";
    
system(command_tab);

}


void qtballit::stampa_tabella()
{
if( (QMessageBox::question(this,tr("Preparazione alla stampa"),tr("Preparare la stampante, poi premere OK; \nchiudere la finestra per annullare la stampa")))==0 )
    {
    char app[22];
    sprintf( app,"%s","lp -o landscape "); 
	    strcat(app,QB_DATA);
    system (app);
    }
}


void qtballit::aboutqt()
{
QMessageBox::aboutQt(this,"About QT");
}


void qtballit::mutant1()
{
//
    if (grm_rb->isChecked())
	mutant1_tl->setText("g.");
	else
	    mutant1_tl->setText("grs.");
}


void qtballit::mutant2()
{
//
    if (mm_rb->isChecked())
	mutant2_tl->setText("mm");
	else
	    mutant2_tl->setText("in.");
}




void qtballit::spaccavirgole()
{
QString buf;
buf=intervalli_le->text();
buf.replace( ",","" , FALSE);
buf.replace( ".","" , FALSE);
intervalli_le->setText(buf);
}


void qtballit::salva_tab1()
{
    
    
    QString s = QFileDialog::getSaveFileName(
	    "data.txt",
	    tr("testo semplice (*.txt)"),
	    this,
	    tr("Salva con nome"),
	    tr("Salva dati") );
      if (s.isNull()==FALSE)
    {
	 FILE *dati_tab1;
	
     if ((dati_tab1=fopen(s, "w")) != NULL)
	 {
    
   
    // dati_tab1=fopen(s, "w");
     
     fprintf ( dati_tab1, "%s", "\n *** DATI DEL PROIETTILE ***\n");	
     
     fprintf ( dati_tab1, "%s", "\n Tipo del proiettile:");
       if (blindato_rb->isChecked())	   
	    fprintf ( dati_tab1, "%s", " Blindato (FMJ)\n");  
	    if (piombo_rb->isChecked())	
		 fprintf ( dati_tab1, "%s", " Piombo (RN)\n");  
		 if (piombowc_rb->isChecked())	
		      fprintf ( dati_tab1, "%s", " Piombo (WC)\n");  
		 
     fprintf ( dati_tab1, "%s", "\n Peso: ");
     fprintf(dati_tab1,"%c%c%c%c",9,9,9,9);
     fprintf (dati_tab1 , "%-3.2f", peso);
    
    //  if (grammi_rb->isChecked())
            fprintf (dati_tab1 , "%s", " g.\n");
    //   else	    
    //	fprintf (dati_tab1 , "%s", " grs.\n");
      
     fprintf ( dati_tab1, "%s", "\n Diametro: ");
     fprintf(dati_tab1,"%c%c%c",9,9,9);
     fprintf (dati_tab1 , "%-3.2f", diametro); 
	  
    //	   if (millim_rb->isChecked())
                      fprintf (dati_tab1 , "%s", " mm.\n");
    //          else
    //	          fprintf (dati_tab1 , "%s", " inch.\n");
	  
     fprintf ( dati_tab1, "%s", "\n Velocita: ");
     fprintf(dati_tab1,"%c%c%c",9,9,9);
     fprintf (dati_tab1 , "%-4.2f", velocita);
    
    //  if (msec_rb->isChecked())
            fprintf (dati_tab1 , "%s", " m/sec.\n");
    // else
    //	fprintf (dati_tab1 , "%s", " ft/sec.\n");
	
         fprintf ( dati_tab1, "%s", "\n Energia (KGM): ");
	  fprintf(dati_tab1,"%c%c",9,9);
         fprintf (dati_tab1 , "%-4.2f\n", energia_kgm);
	 
         fprintf ( dati_tab1, "%s", "\n Energia (J): ");
	  fprintf(dati_tab1,"%c%c%c",9,9,9);
         fprintf (dati_tab1 , "%-4.2f\n", energia_j);
	  
	 fprintf ( dati_tab1, "%s", "\n\n *** PENETRAZIONE IN :");  
	        if (abete_rb->isChecked())
	          fprintf ( dati_tab1, "%s", " LEGNO D'ABETE ***");  
		   if (ferro_rb->isChecked())
		        fprintf ( dati_tab1, "%s", " LAMIERA DI FERRO ***");  
		          if (osso_rb->isChecked())
			       fprintf ( dati_tab1, "%s", " OSSO");  			  
			         if (tessuti_rb->isChecked())
				      fprintf ( dati_tab1, "%s", " TESSUTI CORPOREI ***");  
			
				 
		float buffer=0;
		
	fprintf ( dati_tab1, "%s", "\n\n Effetti terminali\n");
	fprintf ( dati_tab1, "%s", "\n Penetrazione cm.: "); 
		
	buffer=penetraz_le->text().toFloat();
		 fprintf(dati_tab1,"%c%c",9,9);
	fprintf (dati_tab1 , "%-3.2f\n", buffer);	 
		fprintf ( dati_tab1, "%s", "\n Vol. cavita (legno) cm.: "); 
		
	buffer=volcavita_le->text().toFloat();
		 fprintf(dati_tab1,"%c",9);
	fprintf (dati_tab1 , "%-3.1f\n", buffer);	 
				 
	fprintf ( dati_tab1, "%s", "\n Velocita limite su cute m/s: "); 
		
	buffer=vellimite_le->text().toFloat();
		 fprintf(dati_tab1,"%c",9);
	fprintf (dati_tab1 , "%-3.1f\n", buffer);	 
	
	 fprintf ( dati_tab1, "%s", "\n\n *** VELOCITA RESIDUA ***\n\n dopo penetrazione di ");
			  if (velresferro_rb->isChecked())	 
	                           {
			      buffer=spessferro_le->text().toFloat();
			      
			       fprintf (dati_tab1 , "%-3.2f", buffer);	 
			       
			       fprintf ( dati_tab1, "%s", " cm di lamiera di ferro: ");  
			       
			       buffer=msec_le->text().toFloat();
			       fprintf (dati_tab1 , "%-3.2f", buffer);
			       fprintf ( dati_tab1, "%s", " m/s, ");
				 
			       buffer=fsec_le->text().toFloat();
			       fprintf (dati_tab1 , "%-3.2f", buffer);
			       fprintf ( dati_tab1, "%s", " feet/s\n");  
			       
		               }
			  
			   if (velreslegno_rb->isChecked())	 
	                           {
			      buffer=spesslegno_le->text().toFloat();
			       fprintf (dati_tab1 , "%-3.1f", buffer);	 
			       
			       fprintf ( dati_tab1, "%s", " cm di assi di abete: ");  	
			       buffer=msec_le->text().toFloat();
			       fprintf (dati_tab1 , "%-4.2f", buffer);
			       
			       fprintf ( dati_tab1, "%s", " m/s, ");  
			       buffer=fsec_le->text().toFloat();
			       fprintf (dati_tab1 , "%-4.2f", buffer);
			       fprintf ( dati_tab1, "%s", " feet/s\n");  
		               }
			  
 fprintf ( dati_tab1, "%s", "\n\n *** VARIAZIONE DELLA VELOCITA COME FUNZIONE   ***\n *** DELLA VARIAZIONE DELLA LUNGHEZZA DI CANNA ***\n\n");		   
   fprintf ( dati_tab1, "%s", " Velocita in canna nota: ");
   buffer=velnota_le->text().toFloat();
    fprintf(dati_tab1,"%c",9);
   fprintf (dati_tab1 , "%-4.2f", buffer);
  
  if (fsec_cb->isChecked())
        fprintf ( dati_tab1, "%s", " feet/s\n ");
 else
       fprintf ( dati_tab1, "%s", " m/s\n ");
       fprintf ( dati_tab1, "%s", "\n Percorso in canna nota, mm: ");
       buffer=percorso_le->text().toFloat();
        fprintf(dati_tab1,"%c",9);
       fprintf (dati_tab1 , "%-4.1f\n", buffer);
     
     fprintf ( dati_tab1, "%s", "\n Peso della carica di polvere: ");
     buffer=pesocarica_le->text().toFloat();
      fprintf(dati_tab1,"%c",9);
     fprintf (dati_tab1 , "%-3.3f", buffer);
     
   if (grammi2_rb->isChecked())
        fprintf ( dati_tab1, "%s", " g.\n ");
   else
        fprintf ( dati_tab1, "%s", " grs.\n ");
 
  fprintf ( dati_tab1, "%s", "\n Percorso in canna nuova, mm: ");
  buffer=percnuovo_le->text().toFloat();
   fprintf(dati_tab1,"%c",9);
  fprintf (dati_tab1 , "%-4.1f\n", buffer);
  
  fprintf ( dati_tab1, "%s", "\n Velocita in canna nuova, m/s: ");
  buffer=velnuova_le->text().toFloat();
   fprintf(dati_tab1,"%c",9);
  fprintf (dati_tab1 , "%-4.2f\n", buffer);
 
   fprintf ( dati_tab1, "%s", "\n -------------------------------------------------------------------------\n");   
 
     fclose(dati_tab1);
     QMessageBox::information(this,tr("OK"),tr("File salvato"));
      statusBar()->message( QString( tr("Salvato \'%1\'") ).arg( s ), 2000 );
             }
     else
             {
            QMessageBox::critical(this,tr("Errore"),tr("Impossibile salvare il file"));
     statusBar()->message( QString( tr("Impossibile salvare \'%1\'") ).arg( s ), 2000 );
				
             }
      }
  }

void qtballit::addot1()
{
    if(millim_rb->isChecked())
diametro_le->setText("");
    else
	diametro_le->setText(ZERO);
}


void qtballit::addot2()
{
     if(mm_rb->isChecked())
diametropr_le->setText("");
    else
	diametropr_le->setText(ZERO);

}


void qtballit::stampa_dati()
{
 statusBar()->message( QString("not implemented yet"));
}
