/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "AddBodyData.h"
//   #include <stdio.h>
//   #include <iostream>
//  using namespace std;

/**
*Warning,before using, you must execute loadsettings!
*/
AddBodyData::AddBodyData(QWidget *parent)
     : QWidget(parent)
 {
     	ui.setupUi(this);
	//this->filehandler = filehandler;
// 	makeWidgets();
// 	setDefaultValues();
// 	setSignalsSlots();
///	ui.hboxLayout->setSizeConstraint(QLayout::SetMaximumSize);
	//this->setSizePolicy(QSizePolicy::Expanding);
///	ui.vboxLayout->setSizeConstraint(QLayout::SetMaximumSize);
	//this->setMinimumHeight(1000);
	//this->setMinimumHeight(1000);
	labellist =  new QList<QLabel*>();
	datelist = new QList<QDateEdit*>();
	valuelist = new QList<QSpinBox*>();
	buttonlist = new QList<QtrainerButton*>();
}

/**
 * executed when a bodypart gets added (this is a slot)
 */
void AddBodyData::reloadWidgets()
{
removeWidgets();
makeWidgets();
setDefaultValues();
setSignalsSlots();
setSize();
}

/**
 * This method makes the widget large enough, so the scrollarea will scroll :-)
 */
void AddBodyData::setSize()
{
this->setMinimumHeight(100);
this->resize(this->width(),100);
int height = 200 + filehandler->getBodyParts().size()*35;
this->setMinimumHeight(height);
/* this->setMinimumHeight(height);
 ui.hboxLayout->setSizeConstraint(QLayout::SetMaximumSize);
 ui.gridLayout->setSizeConstraint(QLayout::SetMaximumSize);*/
}

/**
* set the width, necessery because of the QScrollArea, slot
* Needs to be executed after selecting this widget from the left-bar
*/
void AddBodyData::rescale()
{
this->resize(parentWidget()->size().width()-20,this->height());

}

/**
 * set all the signals and slots, for the buttons in buttonlist
 */
void AddBodyData::setSignalsSlots()
{

QObject::connect(ui.dateEdit,SIGNAL(dateChanged(const QDate &)),this,SLOT(updateBDate(const QDate&)));
for(int i =0; i<filehandler->getBodyParts().size();i++)
	{
	QObject::connect(buttonlist->at(i),SIGNAL(pressedQtrainer(int)), this, SLOT(appenddata(int)));
	}
}

/**
*save new date into profile
*/
void AddBodyData::updateBDate(const QDate &date){
filehandler->getAge()->setBDate(date);
filehandler->savedata();
}

/**
 * when loading a new profile we need to remove old widgets firsts
 */
void AddBodyData::removeWidgets()
{
for(int i =0; i<labellist->size();i++)
		{
		labellist->at(i)->close();
		datelist->at(i)->close();
		valuelist->at(i)->close();
		buttonlist->at(i)->close();
		}
labellist->clear();
datelist->clear();
valuelist->clear();
buttonlist->clear();
}

/**
 * make all the widgets, indicated by exercise
 */
void AddBodyData::makeWidgets()
{
	int lastrow=0;
	for(int i =0; i<filehandler->getBodyParts().size();i++)
		{
		labellist->insert(i,new QLabel(this));
		datelist->insert(i,new QDateEdit(this));
		valuelist->insert(i,new QSpinBox(this));
		buttonlist->insert(i,new QtrainerButton(this));
		ui.gridLayout->addWidget(labellist->at(i),i+1,0,1,1);
		ui.gridLayout->addWidget(valuelist->at(i),i+1,1,1,1);
		ui.gridLayout->addWidget(datelist->at(i),i+1,2,1,1);
		ui.gridLayout->addWidget(buttonlist->at(i),i+1,3,1,1);
		datelist->at(i)->setCalendarPopup(true);
		QString label = filehandler->getBodyParts().at(i)->objectName();
		label.append(" (");
		label.append(filehandler->getBodyParts().at(i)->unitName());
		label.append(" )");
		labellist->at(i)->setText(label);
		labellist->at(i)->setToolTip(filehandler->getBodyParts().at(i)->getExplanation());
		buttonlist->at(i)->setText(tr("Insert Data"));
		buttonlist->at(i)->setindex(i);
		valuelist->at(i)->setMaximum(999);
		lastrow=i;
		}
}

/**
 * Sets all the widgets to default values
* Needs to be executed after adding data-points
 * @post (date widgets).getdate == today
 * @post (repetitions).get == default for the profile
 * @post (weight).get == last entered value
 */
void AddBodyData::setDefaultValues()
{
ui.dateEdit->setDate(filehandler->getAge()->getBDate().getQDate());

int maxvalue = filehandler->getBodyParts().size();
QDate currentDate = QDate::currentDate();

for(int i =0; i<maxvalue;i++)
	{
 	datelist->at(i)->setDate(currentDate);
	int defaultrepetitions = filehandler->getLatestValue(filehandler->getBodyParts().at(i));
 	valuelist->at(i)->setValue(defaultrepetitions);
	}
}


void AddBodyData::loadsettings(ConfigFileHandlerBodyMeasurements *filehandler)
{
	this->filehandler=filehandler;
	
	removeWidgets();
 	makeWidgets();
 	setDefaultValues();
 	setSignalsSlots();
// 	setSize();
}

/**
 * adds a datapoints and increases the number of datapoints to be displayed with one!
 */
void AddBodyData::appenddata(int index)
{
QDate date = datelist->at(index)->date();
int value = valuelist->at(index)->value();
BodyMeasurement *mes = new BodyMeasurement(filehandler->getBodyParts().at(index),date,value);
	if(filehandler->getBodyParts().at(index)->isdatealreadystored(mes))
	{
		QMessageBox msgBox;
		msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
		msgBox.setText(tr("You already entered data on this day\n Should it be overwritten?"));
		msgBox.setDetailedText(tr("Qtrainer only lets you fill in one datapoint every day.\nEnter your 'best' datapoint, or the datapoint indicated by your schedule."));
 		switch (msgBox.exec()) 
			{
			case QMessageBox::Yes:
			filehandler->getBodyParts().at(index)->linkMeasurement(mes);
			emit dataPointAdded(index);
			break;
			case QMessageBox::No:
     			// no was clicked
			break;
 			default:
     			// should never be reached
     			break;
 			}
	}
	else
	{
	filehandler->getBodyParts().at(index)->linkMeasurement(mes); ///saved into profile, NbPointstoPlot+1
	emit dataPointAdded(index);

	}
}


