/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class AddTestData
 *
 * \brief Provide an example
 *
 * This class is a QWidget which lets the user add datapoints to the profile
 * The datapoints are Test-DataPoints and used for the plots/progress/suggested weights
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef ADDBODYDATA_H
#define ADDBODYDATA_H
#include "ui_AddBodyData.h"
#include "ConfigFileHandlerBodyMeasurements.h"
#include "QtrainerButton.h"
#include <QtGui/QApplication>
#include <QtGui/QWidget>
#include <QtCore/QDate>
#include <QtCore/QSettings>
#include <QtGui/QMessageBox>
#include <QtCore/QList>
#include <QtGui/QLabel>

#include <QtGui/QDateEdit>
#include <QtGui/QGridLayout>
#include <QtGui/QGroupBox>
#include <QtGui/QLabel>
#include <QtGui/QPushButton>
#include <QtGui/QSpinBox>
#include <QtGui/QWidget>

class AddBodyData : public QWidget
 {
     Q_OBJECT

 public:
     	AddBodyData(QWidget *parent);
	void loadsettings(ConfigFileHandlerBodyMeasurements *filehandler);
	void setDefaultValues();
 private:
     	Ui::AddBodyData ui;
	ConfigFileHandlerBodyMeasurements *filehandler;
	void makeWidgets();
	void setSignalsSlots();
	void removeWidgets();
	void setSize();
	QList<QLabel*> *labellist;
	QList<QDateEdit*> *datelist;
	QList<QSpinBox*> *valuelist;
	QList<QtrainerButton*> *buttonlist;
	
private slots:
	void appenddata(int index);
	void updateBDate(const QDate &date);
	
signals:
	void dataPointAdded(int index);
	
public slots:
	void rescale();
	void reloadWidgets();

 };
#endif
