/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "AddBodyPart.h"
//   #include <stdio.h>
//   #include <iostream>
//  using namespace std;

/**
*Warning,before using, you must execute loadsettings!
*/
AddBodyPart::AddBodyPart(QWidget *parent)
     : QWidget(parent)
 {
     	ui.setupUi(this);
	OneBodyPart *widget = new OneBodyPart(this,-1);
	ui.vboxLayout->addWidget(widget);
	widget->setNewBodyPart(true);
	QObject::connect(widget, SIGNAL(saveBodyPart(QString,QString,QString, int)), this, SLOT(checkInformation(QString, QString, QString, int)));
	QObject::connect(widget,SIGNAL(closeWidget()), this, SLOT(close()));
}

/**
*SLOT: the user entered some date, it will be checked and the BodyPart will be added, or user will get 
*warning to correct some stuff.
*/
void AddBodyPart::checkInformation(QString name, QString explanation, QString unit, int index){

///Data is already checked on correctness before savedata signal is emitted, so not neccesary here:
bool nameOK = StringCheck::check(name,false,tr("The name you entered has illegal\n characters in it or is empty."));
bool unitOK = StringCheck::check(unit,false,tr("The unit you entered has illegal\n characters in it or is empty."));
bool explanationOK = StringCheck::check(explanation,true,tr("The explanation you entered contains illegal characters."));
explanation.replace(QString("\n"), "  ");
if (unitOK && nameOK && explanationOK){
	emit addBodyPartToProfile(name, unit, explanation);
	close();
	}

}


