/**
 * \class BMI
 *
 * \brief Provide an example
 *
 * This class is a body Automeasurement.
 * Body Mass Index
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef BMI_H
#define BMI_H
#include <QTime>
#include <QDate>
#include "QStringDates.h"
#include "Measurable.h"
#include "BodyPart.h"
#include <QTextStream>

class Bmi : public Measurable
 {
Q_OBJECT
public:
     	Bmi(int index, QWidget *parent=0);
		
	void setDependecies(BodyPart *height, BodyPart *weight);
	void setHeight(BodyPart *height);
	void setWeight(BodyPart *weight);
	void unSetHeight();
	void unSetWeight();
	QString getExplanation();
	int getValue(StringDate date);
	QVector<QPointF> getVector();

	QString toString();

	bool allDependenciesSet();
	BodyPart *getWeight();
	BodyPart *getHeight();

	void setIndex(int idx);
	int getIndex();
	
private:
	BodyPart *weight;
	BodyPart *height;
	QMap<int,QPointF> addPointsForVector(QMap<int,QPointF> map, BodyPart* part);
	bool allDependenciesSetp;
	bool weightSet;
	bool heightSet;

	int index; //index (ID of Bmi)
 };

#endif //BMI_H
