/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "BmiWidget.h"
// #include <stdio.h>
// #include <iostream>
// using namespace std;

BmiWidget::BmiWidget(QWidget *parent)
     : QWidget(parent)
 {

     	ui.setupUi(this);
	QObject::connect(ui.saveButton,SIGNAL(pressed()),this,SLOT(save()));
}


/**
*Fill the Comboboxes witht the correct information, and selected the right one.
*/
void BmiWidget::loadSettings(ConfigFileHandlerBodyMeasurements *filehandler){
this->filehandler = filehandler;
int selectedHeightIdx = 0;
int selectedWeightIdx = 0;
BodyPart *height = new BodyPart(QString("no"), QString("no"),-1);
BodyPart *weight = new BodyPart(QString("no"), QString("no"),-1);

if(filehandler->getBmi()->allDependenciesSet()){
	height= filehandler->getBmi()->getHeight();
	weight= filehandler->getBmi()->getWeight();
	}


QStringList list;
list<<tr("None");
for(int i=0;i<filehandler->getBodyParts().size();i++){
	QString text= filehandler->getBodyParts().at(i)->objectName();
	text.append("(");
	text.append(filehandler->getBodyParts().at(i)->unitName());
	text.append(")");
	list<<text;

	if(*filehandler->getBodyParts().at(i) == *height){
		selectedHeightIdx=i+1;
		}
	if(*filehandler->getBodyParts().at(i) == *weight){
		selectedWeightIdx=i+1;
		}
	}
ui.weightBox->addItems(list);
ui.heightBox->addItems(list);

ui.weightBox->setCurrentIndex(selectedWeightIdx);
ui.heightBox->setCurrentIndex(selectedHeightIdx);
}

/**
* slot is called when we hit the save button, we emit a signal to the parent widget with the new information
* linked weight, linked height
*/
void BmiWidget::save()
{
int wi = ui.weightBox->currentIndex()-1; //-1 because the first one is "none"
int hi = ui.heightBox->currentIndex()-1;//-1 because the first one is "none"
if(filehandler->getBodyParts().size() > wi){
	if(wi==0){
		filehandler->getBmi()->unSetWeight();
		}
	else{
		filehandler->getBmi()->setWeight(filehandler->getBodyParts().at(wi));
		}
	}

if(filehandler->getBodyParts().size() > hi){
	if(wi==0){
		filehandler->getBmi()->unSetHeight();
		}
	else{
		filehandler->getBmi()->setHeight(filehandler->getBodyParts().at(hi));
		}
	}
filehandler->savedata();
}


