/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class BmiWidget
 *
 * \brief Provide an example
 *
 * This class is a QWidget. It shows one bodypart that can be editted.
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef BMIWIDGET_H
#define BMIWIDGET_H

#include "ui_BmiWidget.h"
#include "ConfigFileHandlerBodyMeasurements.h"
#include <QApplication>
#include <QtGui/QWidget>
#include <QtCore/QList>
#include "StringCheck.h"
#include <QtCore/QVariant>
#include <QtGui/QMessageBox>
#include <QtCore/QSettings>
#include <QtGui/QInputDialog>

class BmiWidget : public QWidget
 {
     Q_OBJECT

public:
     	BmiWidget(QWidget *parent = 0);
	void loadSettings(ConfigFileHandlerBodyMeasurements *filehandler);
private:
	Ui::BmiWidget ui;
	ConfigFileHandlerBodyMeasurements *filehandler;

public slots:
	void save();
signals:
	void saveBmi();
 };

#endif
