//
// C++ Implementation: Training
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "BodyMeasurement.h"
 #include <stdio.h>
 #include <iostream>
 using namespace std;

/**
*constructs a new Body Measurement
*@param part The BodyPart, this is a measurement from
*@param date the date, the measurement was taken
*@param value the value that was measured
*/
BodyMeasurement::BodyMeasurement(BodyPart *part, StringDate date, int value):QObject()
 {
	this->bodyPart = part;
	this->date= date;
	this->value=value;

 }

/**
*constructs a new Body Measurement
*/
BodyMeasurement::BodyMeasurement():QObject()
 {

 }


BodyPart *BodyMeasurement::getBodyPart(){
return bodyPart;
}


/**
*returns bodyPart->objectName()!bodyPart->unitName()!date.getQString()!value!;
*/
QString BodyMeasurement::toString(){
QString result;
QString number="";
number.setNum(getValue());
result=bodyPart->objectName()+"!"+bodyPart->unitName()+"!"+getDate().getQString()+"!"+number+"!";
return result;
}



bool BodyMeasurement::operator<(const BodyMeasurement &other) const
{
return this->getDate().getQDate()<other.getDate().getQDate();
}

StringDate BodyMeasurement::getDate() const{
return date;
}

int BodyMeasurement::getValue() const{
return value;
}