/**
 * \class BodyMeasurement
 *
 * \brief Provide an example
 *
 * This class is a body measurement.
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef BODYMEASUREMENT_H
#define BODYMEASUREMENT_H
#include <QTime>
#include <QDate>
#include "QStringDates.h"
#include "BodyPart.h"
#include <QTextStream>
#include <QObject>

class BodyPart;

class BodyMeasurement:public QObject
 {
Q_OBJECT
public:
     	BodyMeasurement(BodyPart *part, StringDate date, int value);
	BodyMeasurement();
// 	~BodyMeasurement() {};

	BodyPart *getBodyPart();

	StringDate getDate() const;
	int getValue() const;
	bool operator<(const BodyMeasurement &t) const;
	
	QString toString();
	

private:
BodyPart *bodyPart;
StringDate date;
int value;
 };

#endif //BODYMEASUREMENT_H
