//
// C++ Interface: BodyMeasurementsMainWidget
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//

/**
 * \class BodyMeasurementsMainWidget
 *
 * \brief Provide an example
 *
 * This class is a QWidget. All It contains is a StackedWidget, which in his turn contains all the
 * Widgets needed for the BodyMeasurements part of Qtrainer. 
 *
 * \note Class was created to make MainWindow les crowded
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */

#ifndef BODYMEASUREMENTSMAINWIDGET_H
#define BODYMEASUREMENTSMAINWIDGET_H

#include "ui_MainWidget.h"
#include <QtCore/QString>
#include <QtGui/QWidget>
#include <QtGui/QLabel>
#include <QtGui/QToolBar>
#include <QtGui/QListWidget>
#include <QtGui/QScrollArea>
#include <QtCore/QSettings>
#include "QtrainerPlotWidget.h"
#include "ConfigFileHandlerBodyMeasurements.h"
#include "QStringDates.h"
#include "AddBodyData.h"
#include "ViewAndManageBodyParts.h"
#include "AddBodyPart.h"

class BodyMeasurementsMainWidget : public QWidget
 {
     Q_OBJECT

 public:
	BodyMeasurementsMainWidget(ConfigFileHandlerBodyMeasurements *filehandler, QWidget *parent, QListWidget *leftList, QToolBar *toolBar);
	QList<QListWidgetItem*> getQListWidgetItem();
 private:
	
	Ui::MainWidget ui;
	QGroupBox *groupBox_2; ///information groupBox
	QGridLayout *gridLayout;
	QList<QLabel*> informationlabels;
	
	void resizeEvent(QResizeEvent * event);

	bool active; ///true when this widget is active/shown
	
	QToolBar *toolBar;

	///items
	void makeQListWidgetItems();
	QListWidget *leftList;
	QListWidgetItem *InformationItem;
	QListWidgetItem *AddBodyDataItem;
 	QListWidgetItem *ViewAndManageBodyPartsItem;
	QListWidgetItem *PlotBodyPartDataItem;

	///actions
	QAction *actionAdd_Body_Part;
	void makeActions();
	
	ConfigFileHandlerBodyMeasurements *filehandlerBodyMeasurements; 

	AddBodyData *addDataWidget;
	ViewAndManageBodyParts *viewAndManageBodyParts;
	QtrainerPlotWidget *plotBodyPartData;
	
	QScrollArea *scrollareaplot;

	void fillPlotWidget();
	
private slots:
	void setconnections();
	void setToolBar(int index);
	void addBodyPart();
	void addBodyPartToProfile(QString name,QString unit,QString exp);
	void storePlotMethod(QStringList plotmethods, int indexofbodyPart);
	void storeNbPointsToPlot(int number,int indexofbodyPart);
	void updateInformation();
public slots:
	void loadsettings(ConfigFileHandlerBodyMeasurements *filehandlerBodymeasurements);
	void updateVisualisation(int index); //Updata all visual representations of bodypart with index index
	void updateVisualisation(); //update all visualisations
	//void uploadPlots();
	void setCurrentIndex(int index); ///sets stackindex to 'index'
	void logout(); ///prepare for logout-gui-status
	void login(); ///prepare for login-gui-status
	void rescale(); ///triger this when the parent window got resised.

	void itemhasbeenchanged(QListWidgetItem *current);
signals:
	//void setToolBar(int index);
	void updateToolBar();
	void bodyPartWasAdded();
 };

#endif

