/**
 * \class BodyPart
 *
 * \brief Provide an example
 *
 * This class is a body part that can be measured
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef BODYPART_H
#define BODYPART_H
#include <QObject>
#include <QtCore/QString>
#include "BodyMeasurement.h"
#include "Measurable.h"
#include <QtCore/QMap>
#include <QPointF>
#include <QVector>

class BodyMeasurement;

class BodyPart: public Measurable
 {
	Q_OBJECT
public:
     	BodyPart(QString unit, QString object, int index, QWidget *parent =0);
	~BodyPart() {};

// 	void setExplanation(QString explanation);
// 	void setName(QString name);
	void setUnit(QString unit);
// 	void setNbOfPointsToPlot(int number); //the 'number' most recent points will be plotted
// 	void setPlotMethod(QStringList plotMethodList); //which method to use for plotting

	QString toString();
	QString objectName() const;
	QString unitName() const;
// 	QString getExplanation();
// 	QStringList getPlotMethod();
// 	int getNbPointsToPlot();

// 	bool getBezier();
// 	bool getLine();
// 	bool getSpline();

	void linkMeasurement(BodyMeasurement *measurement, bool withsave=true);

	BodyMeasurement *getMeasurement(QDate date);
	QList<BodyMeasurement*> getMeasurements();
	bool hasMeasurement(QDate date);

	QDate getDateLatestMeasurement();
	QVector<QPointF> getVector();
	
	bool isdatealreadystored(BodyMeasurement *mes);

	bool operator==(const BodyPart& s1) const;
private:
	
	QString unit;
// 	QString object;
// 	QString explanation;
	QDate mostRecentMeasurement; ///contains the date of the most recent measurement or some random date when none is set.

// 	QStringList plotMethodList;
// 	int nbPointsToPlot;

	QMap<StringDate,BodyMeasurement*> measurementMap;
signals:
	void saveBodyPart(); 

 };

#endif //BODYPART_H
