/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * \class ConfigFileHandlerBodyMeasurements
 *
 * \brief Provide an example
 *
 * This class takes care of the config files. More precisely it stores the profile information and
 * the data for BodyMeasurements Profiles
 *
 * \note In the future maybe XML will be used
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef CONFIGFILEHANDLERBODYMEASUREMENTS_H
#define CONFIGFILEHANDLERBODYMEASUREMENTS_H

#include "QStringDates.h"
#include "QString"
#include "ConfigFileHandler.h"
#include "BodyMeasurement.h"
#include "Age.h"
#include "Bmi.h"
#include "Measurable.h"


class ConfigFileHandlerBodyMeasurements: public ConfigFileHandler
 {
     Q_OBJECT

public:
     	ConfigFileHandlerBodyMeasurements(QString profilename, QObject *parent=0);
	void logout();
	//void addDatapoint(BodyMeasurement *measurement, bool withsave=true);
	void addBodyPart(BodyPart *part, bool withsave=true);
	QList<BodyPart*> getBodyParts();
	QList<Measurable*> getMeasurables(); //bodyparts and other measurable stuff
	BodyPart *getBodyPart(QString unit, QString object);
	int getLatestValue(BodyPart* part);

	Age *getAge();
	Bmi *getBmi();


private:
	void loaddata(QString profilename);
	void processline(QString line);
	void clearalldatahashes();
	
	Age *age;
	Bmi *bmi;


	//QMap<QString, QList<BodyMeasurement*> > measurementsList; ///<bodypart.ObjectName, BodyMeasurements_in_a_QList>
	QList<BodyPart*> bodyPartList;
public:
	void setprofilename(QString profilename);

public slots:
	void savedata(); ///Writes all to disk
	void saveBodyPart(QString newname, QString newexplanation, QString newunit, int index);
	void deleteBodyPart(int index);
signals:
	void bodyPartChanged(int index); ///index is the index in getBodyParts(), always emitted together with bodyPartChanged()
	void bodyPartChanged(); ///some bodypart changed, always emitted together with bodyPartChanged(int)
	void bodyPartIndexingChanged();
 };


#endif // CONFIGFILEHANDLERBODYMEASUREMENTS_H
