//
// C++ Implementation: OneBodyPart
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "OneBodyPart.h"
//  #include <stdio.h>
//  #include <iostream>
//  using namespace std;

OneBodyPart::OneBodyPart(QWidget *parent, int index)
     : QWidget(parent)
 {
	newBodyPartMode = false;
     	ui.setupUi(this);
	QObject::connect(ui.saveButton,SIGNAL(pressed()),this,SLOT(save()));
	QObject::connect(ui.deleteButton,SIGNAL(pressed()),this,SLOT(deleteBodyPart()));
	QObject::connect(ui.closeButton,SIGNAL(pressed()),this,SLOT(closeBodyPart()));

/**TO SLOW => save manually
// 	QObject::connect(ui.textEditExplaination,SIGNAL(textChanged()),this,SLOT(save()));
// 	QObject::connect(ui.lineEditName1,SIGNAL(textChanged(QString)),this,SLOT(currentNameChanged(QString)));
*/
	ui.closeButton->hide();
	this->index=index;
}



/**
*other Name was chosen => save when we are not in newBodyPartMode
*/
// void OneBodyPart::currentNameChanged(QString newName){
// if(!newBodyPartMode){
// 	save();
// 	}
// }


/**
*emit a signal, telling the closebutton was pressed
*/
void OneBodyPart::closeBodyPart(){
emit closeWidget();
}

/**
 * slot is called when we hit the save button, we emit a signal to the parent widget with the new name,
* and new explainations to be saved
* We also emit the index of this bodypart so we can lookup the old name of this bodypart.
 */
void OneBodyPart::save()
{
///check data
bool nameOK = StringCheck::check(ui.lineEditName->text(),false,tr("The name you entered has illegal\n characters in it or is empty."));
bool explanationOK = StringCheck::check(ui.textEditExplaination->toPlainText(),true,tr("The explanation you entered has illegal characters in it."));
bool unitOK = StringCheck::check(ui.lineEditUnit->text(),false,tr("The unit you entered has illegal\n characters in it or is empty."));

if(explanationOK && nameOK && unitOK){
	QString explanation = ui.textEditExplaination->toPlainText();
	explanation.replace(QString("\n"), "  ");
	emit saveBodyPart(ui.lineEditName->text(),explanation,ui.lineEditUnit->text(),index);
	setTitle(ui.lineEditName->text());
	}

}
/**
*slot triggered when pressing delete button. Emits deleteBodyPart with the index of this bodypart.
*/
void OneBodyPart::deleteBodyPart()
{
emit deleteBodyPart(index);
}

/**
 * set the title (groupbox)
 * @param title Qstring
 */
void OneBodyPart::setTitle(QString title)
{
if(newBodyPartMode){

ui.groupBox->setTitle(QString(""));
///this was the most nasty hack ever :-)
///i set the title to a lot of white space and the style to flat => the groupBox disapears but is still theire
///TODO: do it in a better way :-)
}
///modify mode
else{
ui.groupBox->setTitle(title);}
}


/**
 * set the name of the bodypart lineedit
 * @param  name Qstring
 */
void OneBodyPart::setName(QString name)
{
ui.lineEditName->setText(name);
}

/**
 * set the unit of the bodypart lineedit
 * @param name Qstring
 */
void OneBodyPart::setUnit(QString name)
{
ui.lineEditUnit->setText(name);
}


/**
 * set the explaination QTextEdit
 * @param str 
 */
void OneBodyPart::setExplaination(QString str)
{
ui.textEditExplaination->setText(str);
}


/**
*sets this QWidget into 'new bodypart mode' this means
*Sets the GroupBox (there is only one) to flat
*No Save button but a: Add button
*No delete button
*/
void OneBodyPart::setNewBodyPart(bool var){
	ui.groupBox->setFlat(var);
	if(var){
	newBodyPartMode=true;
	ui.deleteButton->hide();
	ui.closeButton->show();
	ui.saveButton->setText(tr("Add Body Part"));
	setTitle("doesn't matter");
	}
	if(!var){
	newBodyPartMode=false;
	ui.deleteButton->show();
	ui.closeButton->hide();
	ui.saveButton->setText(tr("Save"));
	}
}


