/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ViewAndManageBodyParts.h"
  #include <stdio.h>
  #include <iostream>
  using namespace std;

ViewAndManageBodyParts::ViewAndManageBodyParts(QWidget *parent)
     : QWidget(parent)
 {
	partWidgetList = new QList<OneBodyPart*>();
	buildGui();
 	bmiWidget = new BmiWidget(container);
 	gridLayout->addWidget(bmiWidget, 0, 0,1,2);
	bmiWidget->show();

}

/**
*Builds the gui elements, (scrollwidget, tabbs, ...)
*/
void ViewAndManageBodyParts::buildGui(){
 	QVBoxLayout *layout1 = new QVBoxLayout(this);
	this->setLayout(layout1);
 	QScrollArea *scrollareabodyparts= new QScrollArea(this);
	layout1->addWidget(scrollareabodyparts);
	scrollareabodyparts->show();
	scrollareabodyparts->setFrameShape(QFrame::NoFrame);
	scrollareabodyparts->setFrameShadow(QFrame::Plain);
	container = new QWidget(scrollareabodyparts);
     	gridLayout = new QGridLayout(container);
	container->setLayout(gridLayout);
     	container->show();
	scrollareabodyparts->setWidget(container);	
}

/**
 * convenient function. This function is executed fe when a new profile is openend. same as drawWidgets()
 */
void ViewAndManageBodyParts::loadsettings(ConfigFileHandlerBodyMeasurements *filehandler)
{
this->filehandler=filehandler;
bmiWidget->loadSettings(filehandler);
drawWidgets();
}

/**
 * this method add one OneBodyPart widget for every exercise in the filehandler/exercise class
 */
void ViewAndManageBodyParts::drawWidgets()
{
removeWidgets();
/*this->setMinimumHeight(300);
this->resize(this->width(),300)*/;
int row=1; 
int collumn=0;
	for(int i=0; i< filehandler->getBodyParts().size(); i++)
	{
// 	OneBodyPart *test = new OneBodyPart(container,i);
// 	test->show();

	if(collumn==2){collumn=0;row++;}
	partWidgetList->insert(i, new OneBodyPart(container, i));
	partWidgetList->at(i)->setTitle(filehandler->getBodyParts().at(i)->objectName());
	partWidgetList->at(i)->setExplaination(filehandler->getBodyParts().at(i)->getExplanation());
	partWidgetList->at(i)->setName(filehandler->getBodyParts().at(i)->objectName());
	partWidgetList->at(i)->setUnit(filehandler->getBodyParts().at(i)->unitName());
	partWidgetList->at(i)->show();
	QObject::connect(partWidgetList->at(i),SIGNAL(saveBodyPart(QString,QString,QString, int)), this, SLOT(saveBodyPart(QString, QString,QString, int)));
	QObject::connect(partWidgetList->at(i),SIGNAL(deleteBodyPart(int)), this, SLOT(deleteBodyPart(int)));
	gridLayout->addWidget(partWidgetList->at(i), row, collumn);
	collumn++;

	}
	gridLayout->addItem(new QSpacerItem(10,10, QSizePolicy::Minimum, QSizePolicy::Expanding), row+1, 0);
//row++; ///because we started counting from 0
container->setMinimumHeight(row*360+200);
rescale();
}


/**
 * remove/close all the OneBodyPartWidgets
 */
void ViewAndManageBodyParts::removeWidgets()
{
for(int i=0; i<partWidgetList->size();i++)
{
partWidgetList->at(i)->close();
}
partWidgetList->clear();
}

/**
 * set the width, necessery because of the QScrollArea, slot
 */
void ViewAndManageBodyParts::rescale()
{
//container->resize(parentWidget()->size().width()-40,this->height());
container->resize(this->width()-40,container->height());
//container->setMinimumWidth(300);
}

/**
*Saves all on disk
*/
void ViewAndManageBodyParts::saveAll(){
for(int i=0; i<partWidgetList->size();i++){
	partWidgetList->at(i)->save();
	}
}



/**
 * slot: a bodypart was added, we add it to the list
 */
void ViewAndManageBodyParts::bodyPartWasAdded()
{
emit redrawNeeded();
drawWidgets();
}

/**
 * BodyPart will be renamed and explaination will also be saved
 * @param newname 
 * @param newexplaination 
 * @param index 
 */
void ViewAndManageBodyParts::saveBodyPart(QString newname, QString newexplaination,QString newunit, int index)
{
filehandler->saveBodyPart(newname, newexplaination,newunit, index);
emit redrawNeeded();
}


/**
 * delete a bodypart with nr index
 * @param index 
 */
void ViewAndManageBodyParts::deleteBodyPart(int index)
{
	QMessageBox msgBox;
	msgBox.setStandardButtons(QMessageBox::Yes|QMessageBox::No);
	msgBox.setText(tr("Are you sure you want to delete the exercise?\nAll the entered measurements will also be deleted."));
	switch (msgBox.exec()) 
		{
		case QMessageBox::Yes:
		filehandler->deleteBodyPart(index);
		emit redrawNeeded();
		drawWidgets();
		break;
		default:
		// should never be reached
		break;
		}
rescale();

}
