/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * \class ViewAndManageBodyParts
 *
 * \brief Provide an example
 *
 * This class is a QWidget. It lets the user modify bodyParts and can call the
 * addBodyPart dialog
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */

#ifndef VIEWANDMANAGEBODYPARTS_H
#define VIEWANDMANAGEBODYPARTS_H


#include "ConfigFileHandlerBodyMeasurements.h"
#include "BodyPart.h"
#include "OneBodyPart.h"
#include "BmiWidget.h"
#include <QApplication>
#include <QtGui/QWidget>
#include <QtGui/QMessageBox>
#include <QtCore/QList>
#include <QtGui/QLabel>
#include <QtGui/QScrollArea>

class ViewAndManageBodyParts : public QWidget
 {
     Q_OBJECT

 public:
     	ViewAndManageBodyParts(QWidget *parent = 0);

	void loadsettings(ConfigFileHandlerBodyMeasurements *filehandler);
 private:
	ConfigFileHandlerBodyMeasurements *filehandler;
	QList<OneBodyPart*> *partWidgetList;
	BmiWidget *bmiWidget;
	QWidget *container;
	QGridLayout *gridLayout;
	
	void removeWidgets();
	void buildGui();
private slots:
	
public slots:
	void bodyPartWasAdded();
	void saveAll();
	void drawWidgets();
	void rescale();
	void saveBodyPart(QString newname, QString newexplaination,QString newunit,  int index);	
	void deleteBodyPart(int index);
signals:
	void redrawNeeded();
};


#endif // VIEWANDMANAGEBODYPARTS_H

