/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ConfigFileHandler.h"
// #include <stdio.h>
// #include <iostream>
// using namespace std;

/**
 * the constructor
 * handles all the configfiles and data
 * @param profilename is the name of the profile. It's a QString
 * getSaveEnable()==true
 */
ConfigFileHandler::ConfigFileHandler(QString profilename, QObject *parent):QObject(parent)
{
this->profilename=profilename;
this->saveEnable = true;
loaddata(profilename);
}

/**
*new.getSaveEnable()==true.
*@param enable
*	if(enable == true) the profile is saved to disk to record all prior changes that
*	may or may not be saved
*/
void ConfigFileHandler::setSaveEnable(bool enable){
this->saveEnable=enable;
if(enable){
	savedata();
	}
}

/**
*@return True => changes in the profile are saved to disk
	false => changes are not saved to disk, only in RAM
*/
bool ConfigFileHandler::getSaveEnable(){
return this->saveEnable;
}

/**
 * the constructor
 * handles all the configfiles and data
 * getSaveEnable()==true
 */
ConfigFileHandler::ConfigFileHandler(QObject *parent):QObject(parent)
{
this->saveEnable = true;
}



/**
 * clear/delete all data from all the hashes
 * we don't want to keep old data from old profile when opening a new one.
 */
void ConfigFileHandler::clearalldatahashes()
{

}

/**
*destruct all Trainings.
*/
void ConfigFileHandler::logout(){

}


void ConfigFileHandler::loaddata(QString profilename)
{
///remove all data from Hashes because we only add/insert things.
///we don't want to keep old data from old profile when opening a new one.
clearalldatahashes();
	QFile file;
	QSettings settings("ToonSoft", "Qtrainer");
	settings.beginGroup("ProgramSettings");
	QString profilePath=(settings.value("Profile_Path")).toString();
	settings.endGroup();
QDir::setCurrent(profilePath);
file.setFileName((profilename).append(".QProfile"));
file.open(QIODevice::ReadOnly);
     	QTextStream in(&file);
	int i=1;
	while (!in.atEnd()) {
       	QString line = in.readLine();
        processline(line);
	i++;
	}
}

///empty
void ConfigFileHandler::processline(QString line){
if(line.startsWith("<PowerTraining>") && line.section('!', 1, 1)=="true"){sport=QString("PowerTraining");}
else if(line.startsWith("<Cycling>") && line.section('!', 1, 1)=="true"){sport=QString("Cycling");}
else if(line.startsWith("<Running>") && line.section('!', 1, 1)=="true"){sport=QString("Running");}
else if(line.startsWith("<BodyMeasurements>") && line.section('!', 1, 1)=="true"){sport=QString("BodyMeasurements");}
}

/**
 * backup profile to profile.QProfile~
 */
void ConfigFileHandler::backup()
{
		QSettings settings("ToonSoft", "Qtrainer");
		settings.beginGroup("ProgramSettings");
		QString profilePathSource=(settings.value("Profile_Path")).toString();
		settings.endGroup();
		profilePathSource.append("/");
		profilePathSource.append(getprofilename());
		profilePathSource.append(".QProfile");
		QFile file(profilePathSource);
		QString profilePathDest = QString(profilePathSource+"~");
		if(QFile::exists(profilePathDest)){QFile(profilePathDest).remove();} ///overriding
		file.copy(profilePathDest);
}

void ConfigFileHandler::savedata()
{	
	if(getSaveEnable()){
	backup(); //backup to profile.QProfile~
	}
}

QString ConfigFileHandler::getprofilename()
{
return this->profilename;
}


/**
 * sets the profile to <profilename>
 * reload the data from the configfile
 * @param profilename a QString representing the profilename
 */
void ConfigFileHandler::setprofilename(QString profilename)
{
this->profilename=profilename;
///when loading a new profile we need to remove the exercises of the old profile from the ordered lists
clearalldatahashes();
///end remove the data from odered lists
loaddata(profilename);
}

/**
*Returns the name of the profile-type
*/
QString ConfigFileHandler::getSport(){
return this->sport;
}

// int ConfigFileHandler::getdaysfrom1january(QString date)
// {
// QDate mydate=StringDate(date).getQDate();
// QDate endofyear;
// endofyear.setDate(mydate.year()+1,1,1);
// return 356 - mydate.daysTo(endofyear);
// }
// 
// int ConfigFileHandler::getdaysfrom1jan2000(QString date)
// {
// QDate mydate = StringDate(date).getQDate();
// QDate endofyear;
// endofyear.setDate(2000,1,1);
// return -mydate.daysTo(endofyear);
// 
// }


