/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * \class ConfigFileHandler
 *
 * \brief Provide an example
 *
 * This class takes care of the config files. More precisely it stores the profile information and
 * the data.
 *
 * \note In the future maybe XML will be used
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef CONFIGFILEHANDLER_H
#define CONFIGFILEHANDLER_H

#include <QApplication>
#include <QtCore/QFile>
#include <QtCore/QTextStream>
#include <QtCore/QSettings>
#include <QtCore/QString>
#include <QtCore/QDate>
#include <QtCore/QMultiHash>
#include <QtCore/QHash>
#include <QtCore/QMap>
#include <QtCore/QHashIterator>
//#include <QMutableHashIterator>
#include <QtCore/QListIterator>
#include <QtCore/QVector>
#include <QtCore/QPointF>
#include <QtCore/QStringList>
#include <QtCore/QVectorIterator>
#include <QtCore/QList>
#include <QtCore/QDir>
#include "PowerTraining/Training.h"
#include "QStringDates.h"
#include "PowerTraining/TrainingSchedule.h"
#include "PowerTraining/ScheduleOccurrence.h"
#include <QtCore/QObject>
#include <QtCore/QTime>



class ConfigFileHandler: public QObject
 {
     Q_OBJECT

public:
     	ConfigFileHandler(QString profilename, QObject *parent=0);
	ConfigFileHandler(QObject *parent=0);
	
	void logout();
	QString getSport();
protected:
	QString sport; //contains the name of the profiletype
	QString profilename;
	void loaddata(QString profilename);
	//int getdaysfrom1january(QString date); ///name says it all
	//int getdaysfrom1jan2000(QString date); ///name says it all
private:
	void clearalldatahashes();
	void processline(QString line);
	void backup();
	
	bool saveEnable; ///true => changes are saved to profile
public:
	QString getprofilename();
	void setprofilename(QString profilename);
	void setSaveEnable(bool enable);
	bool getSaveEnable();
	

public slots:
	void savedata(); ///Writes all to disk
 };


#endif // CONFIGFILEHANDLER_H
