/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class Configuration
 *
 * \brief Provide an example
 *
 * This class is a QWidget. It is the configuration dialog
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include "ui_Configuration.h"
#include <QApplication>
#include <QtGui/QWidget>
#include <QtCore/QSettings>
#include <QtGui/QFileDialog>
#include <QtGui/QMessageBox>
//#include <Qt3Support/Q3UrlOperator>

class Configuration : public QWidget
 {
     Q_OBJECT

public:
     	Configuration(QWidget *parent = 0 );
	
private:
     	Ui::Configuration ui;
	void loadSettings();
	bool isValidPath(QString path);
	void notAValidPath();
	void copyProfilesToNewDir();
	QStringList profilesToBeDeleted;
	QStringList profilesToBeImported;

	void deleteProfilesFromDisk();
	QString getProfileNameFromPath(QString path);
	void importsProfilesForReal();

	void selectAutoLogin(QString selection);

private slots:
	void cancel();
	void save();
	void deleteProfile();
	void importProfile();
	void openFileDialog();
signals:
	void configurationDialogClosed();
	void profileDeletedFromDisk(QString profilename); 

 };

#endif
