//
// C++ Implementation: LoginRegisterWidget
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "LoginRegisterWidget.h"

LoginRegisterWidget::LoginRegisterWidget(QWidget *parent)
     : QWidget(parent)
 {
	ui.setupUi(this);
	hideSomethingWrongMessage();
	QObject::connect(ui.registerButton, SIGNAL(pressed()),this,SLOT(registerUser()));
	QObject::connect(ui.uploadButton, SIGNAL(pressed()),this,SLOT(sendUploadSignal()));
	QObject::connect(ui.uploadButton, SIGNAL(pressed()),this,SLOT(hideSomethingWrongMessage()));
	QObject::connect(ui.registerButton, SIGNAL(pressed()),this,SLOT(hideSomethingWrongMessage()));
	
	///enter login information?
	QSettings settings("ToonSoft", "Qtrainer");
	settings.beginGroup("ProgramSettings");
	if(settings.value("RememberLoginInformation").toInt()==2){setLoginInformation();}
	settings.endGroup();
	QObject::connect(ui.closeButton, SIGNAL(clicked()),this,SLOT(closeWidget()));
}

/**
*When closing the widget, we first save the login information if checkBox is checked
*/
void LoginRegisterWidget::closeWidget(){
int state = ui.checkBox->checkState();
QSettings settings("ToonSoft", "Qtrainer");
settings.beginGroup("ProgramSettings");
settings.setValue("RememberLoginInformation",state);
settings.endGroup();
if(state==2){
///checked => save loginInformation
QSettings settings("ToonSoft", "Qtrainer");
settings.beginGroup("ProgramSettings");
settings.setValue("UserName",ui.usernameEdit->text());
settings.setValue("Password",ui.passwordEdit->text());
settings.endGroup();
}
this->close();
}

/**
*this method sets the login information. I may only be executed if RememberLoginInformation==2
*/
void LoginRegisterWidget::setLoginInformation(){
QSettings settings("ToonSoft", "Qtrainer");
settings.beginGroup("ProgramSettings");
ui.usernameEdit->setText(settings.value("UserName").toString());
ui.passwordEdit->setText(settings.value("Password").toString());
settings.endGroup();
ui.checkBox->setCheckState(Qt::Checked);
}

void LoginRegisterWidget::hideSomethingWrongMessage(){
ui.labelWrong->hide();
}

void LoginRegisterWidget::registerUser(){
QString username = ui.usernameEdit->text();
/*QByteArray barray = QByteArray();
barray.append(ui.passwordEdit->text());
QByteArray crypto = QCryptographicHash::hash(barray,QCryptographicHash::Md5);
QString password = QString(crypto);*/
QString password = ui.passwordEdit->text();

	QSettings settings("ToonSoft", "Qtrainer");
	settings.beginGroup("ProgramSettings");
	QString url = settings.value("DatabaseURL").toString();
	settings.endGroup();
	QxtXmlRpcClient *myClient = new QxtXmlRpcClient(QUrl(url));

	QObject::connect(myClient, SIGNAL(finished(int,QVariant)),this,SLOT(finished(int,QVariant)));
	QObject::connect(myClient, SIGNAL(fault(int,int,QString)),this,SLOT(fault(int,int,QString)));
	QObject::connect(myClient, SIGNAL(parseError(int,QString)),this,SLOT(parseError(int,QString)));
	QObject::connect(myClient, SIGNAL(networkError(int,QString)),this,SLOT(networkError(int,QString)));
	QList<QVariant> params;
	params<<username<<password;
	int i = myClient->call(QString("registeruser"), params);
}

void LoginRegisterWidget::parseError(int callId, QString errorMsg){
	QMessageBox msgBox;
	msgBox.setIcon(QMessageBox::Critical);
	msgBox.setStandardButtons(QMessageBox::Ok);
	msgBox.setText(tr("A parse error occured.\nThis is probably Qtrainer's fault."));
	msgBox.exec();
}

void LoginRegisterWidget::networkError(int callId, QString errorMsg){
	QMessageBox msgBox;
	msgBox.setIcon(QMessageBox::Critical);
	msgBox.setStandardButtons(QMessageBox::Ok);
	msgBox.setText(tr("A network error occured."));
	msgBox.exec();
}

void LoginRegisterWidget::finished(int callId, QVariant retValue){
if(retValue.toString()=="succes"){
	QMessageBox msgBox;
	msgBox.setIcon(QMessageBox::Information);
	msgBox.setStandardButtons(QMessageBox::Ok);
	msgBox.setText(tr("Registration succesfull. You can now upload your plots."));
	msgBox.exec();
}
if(retValue.toString()=="false"){
	QMessageBox msgBox;
	msgBox.setIcon(QMessageBox::Information);
	msgBox.setStandardButtons(QMessageBox::Ok);
	msgBox.setText(tr("Registration _NOT_ succesfull. The username already exists."));
	msgBox.exec();
}

QTextStream cout(stdout, QIODevice::WriteOnly);
cout<<retValue.toString()<<endl;
}


void LoginRegisterWidget::fault(int callId, int faultCode, QString faultString){
	QMessageBox msgBox;
	msgBox.setStandardButtons(QMessageBox::Ok);
	msgBox.setText(tr("Something went wrong.\n")+faultString);
	msgBox.exec();
}

void LoginRegisterWidget::sendUploadSignal(){
QString username = ui.usernameEdit->text();
QString password = ui.passwordEdit->text();
emit uploadPlots(username,password);
}


void LoginRegisterWidget::setprogressBarMax(int i){
ui.progressBar->setMaximum(i);
}

void LoginRegisterWidget::setprogressBarMin(int i){
ui.progressBar->setMinimum(i);
}

void LoginRegisterWidget::increaseProgressBar(){

if(ui.progressBar->value()<ui.progressBar->maximum()){
ui.progressBar->setValue(ui.progressBar->value()+1);}
}

void LoginRegisterWidget::showSomethingWrongMessage(){
ui.labelWrong->show();
}