/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class MainWindow
 *
 * \brief Provide an example
 *
 * This class is a QWidget. The applications main widget. displays all the different modules
 *
 * \note Nothing to note
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "ui_MainWindow.h"
#include <QApplication>
#include <QtCore/QString>
#include <QListWidgetItem>
#include <QtGui/QWidget>
#include <QtCore/QSettings>
#include <QtGui/QScrollArea>
#include "NewProfileWizard.h"
#include "QtrainerWelcomsWidget.h"
#include "OpenExistingProfile.h"
#include "PowerTraining/PowerTrainingMainWidget.h"
//#include "TrainPrograms.h"  /// contains class: ViewAndManageSchedule
#include "PowerTraining/ConfigFileHandlerPowerTraining.h"
#include "BodyMeasurements/ConfigFileHandlerBodyMeasurements.h"
#include "ConfigFileHandler.h"
#include "Configuration.h"
#include <QtGui/QMessageBox>
#include <QtCore/QMutex>
#include "QStringDates.h"
#include "PowerTraining/PowerTrainingMainWidget.h"
#include "BodyMeasurements/BodyMeasurementsMainWidget.h"

class MainWindow : public QMainWindow
 {
     Q_OBJECT

 public:
    	MainWindow(QWidget *parent = 0);
 private:
	bool loggedin;

	bool isMessageBoxProgressAlreadyShown;

     	Ui::MainWindow ui;
	//QWidget *WizardWidget;
// 	QListWidgetItem *InformationItem;
// 	QListWidgetItem *SettingsItem;
// 	QListWidgetItem *AddDataItem; ///used for the body measurmeents and powertraining at the moment
// 	QListWidgetItem *ViewDataPlottedItem;
// 	QListWidgetItem *ViewDataTabledItem;
// 	QListWidgetItem *ViewProgramsItem;
// 	QListWidgetItem *ViewExercisesItem;
// 	QListWidgetItem *ViewPlannerItem;

	///actions
	QAction *actionNew_Project;
    	QAction *actionOpen_Existing_Project;
    	QAction *actionExit_Qtrainer;
    	QAction *actionAbout_Qtrainer;
    	QAction *actionConfigure_Qtrainer;
    	QAction *actionExport;
    	QAction *actionExport_to_HTML;
    	QAction *actionLogout;
    	QAction *actionRecover_from_backup;
	void makeActions();

	PowerTrainingMainWidget *powerTrainingMainWidget;
	BodyMeasurementsMainWidget *bodyMeasurementsMainWidget;
	QtrainerWelcomsWidget *qtrainerWelcomsWidget;
	
	void populatelistWidget();
	void setMenuConnections(); 
	//void setLeftFrame();
	void loadwidgets(); ///this is called when starting/opening a project	
	
	NewProfileWizard *newprofilewizard;
	OpenExistingProfile *openprojectwizard;
	//AddData *adddatawidget;
//	AddBodyData *addbodydatawidget;
	/*QScrollArea *scrollareaplot;
	QScrollArea *scrollareaadd;
	QScrollArea *scrollareaexercises;
	QScrollArea *scrollareaprograms;
	PlotWidget *plotwidget;
	Grid *grid;
	ViewAndManageSchedule *programswidget;
	ViewAndManageExercise *exerciseswidget;
	PlannerWrap *plannerwidget;*/

	ConfigFileHandlerPowerTraining *filehandlerPowerTraining; ///filehandler for powertraining profiles
	ConfigFileHandlerBodyMeasurements *filehandlerBodyMeasurements;
	
	OpenExistingProfile *openprofilewizard;

	bool powertraining; //profiltype == powertraining
	bool body;	//profiltype == body

	void setconnections();
	void resizeEvent(QResizeEvent * event);
	void setUrls(); ///if no Database of Forum url is set, set default one


	void loadPowerTrainingWidget();
	void loadBodyMeasurementWidget();
	//QMutex *mutex_for_thread;

	//QString getProfileLabel();

private slots:
	//void setProgress(QString progressstring, QString numberString);
	//void askUserToTurnOfProgress();

	void newproject();
	void openproject();
	//void loadnewproject();
	void loadNewPowerTraining(ConfigFileHandlerPowerTraining *filehandler);
	void loadNewBodyMeasurements(ConfigFileHandlerBodyMeasurements*);

	//void itemhasbeenchanged(QListWidgetItem *current); ///when clicking something in the left bar
	void openConfigurationDialog();
	void configurationChanged();
	void openAboutDialog();
	void logout();
	void exportProfile();
	void recoverProfile();
	void profileDeletedFromDisk(QString profilename);
	//void showLatestTraining();
	//void updateInformation(int exerciseThatRecievedANewDataPoint); ///the argument isn't used, it is only so it can be connected to a signal that sends an integer
	
	//void uploadButtonPressed(); ///needs a private slot to decide what to upload (according to which tab is active)
public slots:
	//void updateTrainingInformation();
	//void someTrainingScheduleChanged(QString oldName, TrainingSchedule *newschedule);
	bool openproject(QString profilename);
	void setToolBar();
signals:
	void resizeWidgets();
	void uploadPlots();
 };
#endif
