/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "NewProfileWizard.h"
//  #include <stdio.h>
//  #include <iostream>
//  using namespace std;

NewProfileWizard::NewProfileWizard(QWidget *parent)
     : QWidget(parent)
{
     	ui.setupUi(this);
	
	QObject::connect(ui.okButton,SIGNAL(clicked()), this, SLOT(finish()));
}

/**
*check all values, enter default stuff into profile, emit signals, close widgets
*/
void NewProfileWizard::finish()
{
if(checkValues()){
	if(ui.radioPowerTraining->isChecked()){
		ExerciseHandler *exercise = new ExerciseHandler(0);
		filehandlerPowerTraining = new ConfigFileHandlerPowerTraining("default",exercise);
		exercise->setParent(filehandlerPowerTraining);
	
		filehandlerPowerTraining->setprofilename(ui.LineEditName->text());
		addDefaultExercises(); 
		addDefaultSchedules();
		filehandlerPowerTraining->getExercise()->addExerciseTag(tr("No tag")); ///default tag is the 'no tag'-tag :-)

		addProfile(ui.LineEditName->text());
	
		emit finishedPowerTraining(filehandlerPowerTraining);	
		emit finished();
		this->close();
	}

	if(ui.radioBodyMeasurements->isChecked()){
		filehandlerBodyMeasurements = new ConfigFileHandlerBodyMeasurements(ui.LineEditName->text());
		filehandlerBodyMeasurements->setprofilename(ui.LineEditName->text());
		addDefaultBodyParts();

		addProfile(ui.LineEditName->text());
		emit finishedBodyMeasurements(filehandlerBodyMeasurements);
		emit finished();	
		this->close();
	}
}
}

/**
*Adds some bodyparts to the profile
*/
void NewProfileWizard::addDefaultBodyParts(){
int index = filehandlerBodyMeasurements->getMeasurables().size();
BodyPart *part1 = new BodyPart(QString("cm"), QString("length"), index);
BodyPart *part2 = new BodyPart(QString("kg"), QString("weight"), index+1);
BodyPart *part3 = new BodyPart(QString("%"), QString("fat"), index+2);

filehandlerBodyMeasurements->addBodyPart(part1,false);
filehandlerBodyMeasurements->addBodyPart(part2,false);
filehandlerBodyMeasurements->addBodyPart(part3,false);
filehandlerBodyMeasurements->getBmi()->setHeight(part1);
filehandlerBodyMeasurements->getBmi()->setWeight(part2);
filehandlerBodyMeasurements->savedata();
}


/**
*adds 'name' to the list of profiles in the settings-file
*/
void NewProfileWizard::addProfile(QString name){
QSettings settings("ToonSoft", "Qtrainer");
settings.beginGroup("ProgramSettings");
QString newlist = (((settings.value("Profiles")).toString()).append("!")).append(name);
settings.setValue("Profiles", newlist);
settings.endGroup();
}

void NewProfileWizard::addDefaultExercises()
{
if(ui.radioPowerTraining->isChecked())
{
filehandlerPowerTraining->addExercise("Bench Press", tr("Preparation: Lie supine on bench. Dismount barbell from rack over the upper chest using a wide oblique overhand grip. Execution: Lower weight to upper chest. Press bar until arms are extended. Repeat."),QStringList( filehandlerPowerTraining->getExercise()->getPossibleMuscleList().at(0)));
filehandlerPowerTraining->addExercise("Biceps Curl", tr("Preparation: Grasp bar with a shoulder width under hand grip. Execution: With elbows to side, raise bar until forearms are vertical. Lower until arms are fully extended. Repeat. "),QStringList( filehandlerPowerTraining->getExercise()->getPossibleMuscleList().at(5)));
filehandlerPowerTraining->addExercise("Neck Press", tr("Preparation: Grasp barbell with overhand grip from rack or clean from floor. Position bar behind neck. Execution: Press bar until arms are extended overhead. Return behind neck and repeat. "),QStringList( filehandlerPowerTraining->getExercise()->getPossibleMuscleList().at(1)));
filehandlerPowerTraining->addExercise("Rowing", tr("Preparation: Sit on platform with knees bent and grasp cable attachment. Straighten lower back and position knees with a slight bend.  Execution: Pull cable attachment to waist. Pull shoulders back and push chest forward during contraction. Return until arms are extended and shoulders are stretched forward. Repeat. "),QStringList( filehandlerPowerTraining->getExercise()->getPossibleMuscleList().at(1)));
filehandlerPowerTraining->addExercise("RomboiDei", tr("No description available yet"),QStringList( filehandlerPowerTraining->getExercise()->getPossibleMuscleList().at(4)));
filehandlerPowerTraining->addExercise("Squat", tr("Preparation: From a rack with barbell upper chest height, position barbell on the back of the shoulders and grasp bar to sides. Dismount bar from rack. Execution: Descend until knees and hips are fully bent. Extend knees and hips until legs are straight. Return and repeat. "),QStringList( filehandlerPowerTraining->getExercise()->getPossibleMuscleList().at(10)));
filehandlerPowerTraining->addExercise("Neck Pull", tr("Preparation: Grasp cable bar with a wide grip. Sit with thighs under supports. Execution: Pull down cable bar behind neck. Return until arms and shoulders are fully extended. Repeat. "),QStringList( filehandlerPowerTraining->getExercise()->getPossibleMuscleList().at(3)));
}
}


void NewProfileWizard::addDefaultSchedules()
{
if(ui.radioPowerTraining->isChecked())
	{
	TrainingSchedule *test = new  TrainingSchedule(tr("Test"),tr("This schedule is used to test yourself. Enter the data from this schedule into Qtrainer so it can monitor your progress.  The weights/Repetitions from the Data-Points from this schedule are used to calculate the weights you should use for all the ohter schedules. It is very important to do this schedule quite often (1 time per week or once every two weeks. You need to use as much weight as possible, and do as many repetitions as possible. Aim at 10 repetitions."));
	test->addRotation();
	test->setPerformance(0,0,100);
	test->setNumberOfTimesExerciseIsDone(0,0,10);
	filehandlerPowerTraining->addSchedule(test);

	TrainingSchedule *dropSets = new TrainingSchedule(tr("Drop Sets"),tr("Principle: You begin by reaching failure with a weight, as soon as you hit failure, lessen the weight, and then continue the set until failure is reached again. In Qtrainer it is implemented this way: Do every exercise immediatly 3 timeswith only 20seconds pause in between. Then procede with the next exercise after a pause of 2 minutes."));
	dropSets->addRotation();
	dropSets->addRepetition(0);
	dropSets->addRepetition(0);
	dropSets->setPerformance(0,0,100);
	dropSets->setPerformance(0,1,90);
	dropSets->setPerformance(0,2,70);
	dropSets->setNumberOfTimesExerciseIsDone(0,0,12);
	dropSets->setNumberOfTimesExerciseIsDone(0,1,8);
	dropSets->setNumberOfTimesExerciseIsDone(0,2,6);
	filehandlerPowerTraining->addSchedule(dropSets);
	

	TrainingSchedule *pyramid = new TrainingSchedule(tr("Pyramid"),tr("Principle: Start with high repetitions but low weight, the second set uses heigher weihts and the 3th set goes maximal. The final set uses a low weight/high repetitions again."));
	pyramid->addRotation();
	pyramid->addRotation();
	pyramid->addRotation();
	pyramid->addRotation();
	pyramid->setPerformance(0,0,50);
	pyramid->setPerformance(1,0,90);
	pyramid->setPerformance(2,0,90);
	pyramid->setPerformance(3,0,70);
	pyramid->setNumberOfTimesExerciseIsDone(0,0,16);
	pyramid->setNumberOfTimesExerciseIsDone(1,0,10);
	pyramid->setNumberOfTimesExerciseIsDone(2,0,6);
	pyramid->setNumberOfTimesExerciseIsDone(3,0,12);
	filehandlerPowerTraining->addSchedule(pyramid);
	}
}

/**
 * This method return true if the values the user entered where valid
 * else it tells the user, he needs to check the values
 * @return 
 */
bool NewProfileWizard::checkValues()
{
bool nameOK = StringCheck::check(ui.LineEditName->text(),false,tr("The ProfileName you entered has illegal\n characters in it or is empty."));
if(!nameOK){return false;}
else{
///check if it already exists, ...

QString currentprofiles;
QSettings settings("ToonSoft", "Qtrainer");
settings.beginGroup("ProgramSettings");
currentprofiles = settings.value("Profiles","").toString();
settings.endGroup();
///parcing
int nbProfiles= currentprofiles.count("!");
QStringList currentProfiles;
for(int i=1;i<nbProfiles+1;i++){
	currentProfiles<<currentprofiles.section('!', i, i);
	}
///legal
if(currentProfiles.contains(ui.LineEditName->text())){
	QMessageBox::warning(this, tr("Qtrainer: New Profile Wizard"),
        tr("The profilename you entered already exists!"),QMessageBox::Ok);
	return false;
	}

if(!(ui.radioPowerTraining->isChecked() ||ui.radioCycling->isChecked() || ui.radioRunning->isChecked() || ui.radioBodyMeasurements->isChecked())  ){
	QMessageBox::warning(this, tr("Qtrainer: New Profile Wizard"),
        tr("You must select a sport"),QMessageBox::Ok);
	return false;
	}
}
///no negative checks => ok => return true
return true;
}
