/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * \class NewProfileWizard
 *
 * \brief Provide an example
 *
 * This class is a QWidget. It lets the user make a new profile. 
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */

#include "ui_NewProfileWizard.h"
#include "PowerTraining/ConfigFileHandlerPowerTraining.h"
#include "BodyMeasurements/ConfigFileHandlerBodyMeasurements.h"
#include "PowerTraining/ExerciseHandler.h"
#include "StringCheck.h"
#include <QApplication>
#include <QtGui/QWidget>
#include <QtCore/QFile>
#include <QtCore/QTextStream>
#include <QtCore/QSettings>
#include <QtCore/QStringList>
#include <QtGui/QMessageBox>


class NewProfileWizard : public QWidget
 {
     Q_OBJECT

 public:
     NewProfileWizard(QWidget *parent = 0);


 private:
     	Ui::NewProfileWizard ui;
	ConfigFileHandlerPowerTraining *filehandlerPowerTraining;
	ConfigFileHandlerBodyMeasurements *filehandlerBodyMeasurements;
	void addDefaultExercises();
	void addDefaultSchedules();
	void addDefaultBodyParts();
	bool checkValues();

	void addProfile(QString name);
private slots:
	void finish();
signals:
	void finishedPowerTraining(ConfigFileHandlerPowerTraining *filehandlerPowerTraining);
	void finishedBodyMeasurements(ConfigFileHandlerBodyMeasurements *filehandlerBody);
	void finished(); //always emitted when some profile has been created.
 };


