/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "OpenExistingProfile.h"
//  #include <stdio.h>
//  #include <iostream>
//  using namespace std;


/**
*@param filehandler The ConfigFileHandler that is common for every kind of sports.
*It justs registeres the profilename and the type of profile.
*/
OpenExistingProfile::OpenExistingProfile(QWidget *parent)
     : QWidget(parent)
 {
     	ui.setupUi(this);
	///show open profile dialog on startup
	QSettings settings("ToonSoft", "Qtrainer");
	settings.beginGroup("ProgramSettings");
	if(settings.value("OpenExistingProfileOnStartup").toInt()==2){ui.checkBox->setCheckState(Qt::Checked);}
	if(settings.value("OpenExistingProfileOnStartup").toInt()==0){ui.checkBox->setCheckState(Qt::Unchecked);}
	settings.endGroup();
	///load profiles in lost
	populatelist();
	///connections
	QObject::connect(ui.okbutton,SIGNAL(pressed()),this, SLOT(loadprofile()));
	QObject::connect(ui.checkBox,SIGNAL(stateChanged(int)),this, SLOT(savesettings(int)));
	QObject::connect(ui.listWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(itemClicked(QListWidgetItem*)));
	something_selected=false;
}

void OpenExistingProfile::savesettings(int state)
{
	QSettings settings("ToonSoft", "Qtrainer");
	settings.beginGroup("ProgramSettings");
	settings.setValue("OpenExistingProfileOnStartup", ui.checkBox->checkState());
     	settings.endGroup();
	
}

void OpenExistingProfile::loadprofile()
{
	if(something_selected){
	QString profilename = (ui.listWidget->currentItem())->text();
	emit signalfinished(profilename);
	this->close();
	}
}

void OpenExistingProfile::populatelist()
{
	///read the necessarry settings
	QSettings settings("ToonSoft", "Qtrainer");
	settings.beginGroup("ProgramSettings");
	QString allprofiles=(settings.value("Profiles")).toString();
     	settings.endGroup();

	///append them all to the list.
	int i=1;
	while((allprofiles.section('!',i,i)).size()>0)
	{
		QListWidgetItem *SettingsItem = new QListWidgetItem(allprofiles.section('!', i, i),ui.listWidget);
		i++;
	}
}

void OpenExistingProfile::itemClicked(QListWidgetItem* item){
this->something_selected=true;
}
