/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "AddData.h"
//#include <stdio.h>
//#include <iostream>
//using namespace std;

AddData::AddData(QWidget *parent, ConfigFileHandlerPowerTraining *filehandler)
     : QWidget(parent)
{
     	ui.setupUi(this);
	this->filehandler = filehandler;

	buildGui();
	setSignalsSlots();
}


/**
*Builds the gui elements, (scrollwidget, tabbs, ...)
*/
void AddData::buildGui(){
	///TAB 1
 	QVBoxLayout *layout1 = new QVBoxLayout(ui.tab1);
	layout1->setMargin(0);
	ui.tab1->setLayout(layout1);
 	QScrollArea *scrollareaexercises= new QScrollArea(ui.tab1);
	layout1->addWidget(scrollareaexercises);
	scrollareaexercises->show();
	scrollareaexercises->setFrameShape(QFrame::NoFrame);
	scrollareaexercises->setFrameShadow(QFrame::Plain);
	tab1Content = new AddTestData(this,filehandler);
     	tab1Content->show();
	scrollareaexercises->setWidget(tab1Content);

	///TAB 2
	QVBoxLayout *layout2 = new QVBoxLayout;
	layout2->setMargin(0);
      	ui.tab2->setLayout(layout2);
 	tab2Content = new AddOtherData(this,filehandler);
 	layout2->addWidget(tab2Content);
 	tab2Content->show();
}




/**
 * set all the signals and slots, for the buttons in buttonlist
 */
void AddData::setSignalsSlots()
{
QObject::connect(tab1Content,SIGNAL(dataPointAdded(int)),this,SLOT(testDataPointAdded(int)));
}


void AddData::testDataPointAdded(int index){
emit dataPointAdded(index);

}


void AddData::selectTab(int nb){
ui.tabWidget->setCurrentIndex(nb);
}

/**
*laat gui toe om data van myTrainign in te geven
*/
void AddData::insertDataForTraining(Training *myTraining){
selectTab(1);
tab2Content->insertDataForTraining(myTraining);
}

void AddData::loadsettings(ConfigFileHandlerPowerTraining *filehandler)
{
this->filehandler = filehandler;
tab1Content->loadsettings(filehandler);
tab2Content->loadsettings(filehandler);
}

void AddData::reloadWidgets(){
tab1Content->reloadWidgets();
}

void AddData::rescale(){
tab1Content->rescale();
}

/**
*SLOT: triggered when training is added or changed => reload the AddOtherData widget's combobox
*/
void AddData::trainingsChanged(){
tab2Content->fillComboBoxes();
}

