/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class AddData
 *
 * \brief Provide an example
 *
 * This class is a QWidget which lets the user add datapoints to the profile
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef ADDDATA_H
#define ADDDATA_H
#include "ui_AddData.h"
#include "AddTestData.h"
#include "AddOtherData.h"
#include "ConfigFileHandlerPowerTraining.h"
#include "ExerciseHandler.h"
#include <QtGui/QScrollArea>

class AddData : public QWidget
 {
     Q_OBJECT

 public:
     	AddData(QWidget *parent, ConfigFileHandlerPowerTraining *filehandler);
	void loadsettings(ConfigFileHandlerPowerTraining *filehandler);
	void selectTab(int nb);
	void insertDataForTraining(Training *myTraining);
 private:
     	Ui::AddData ui;
	ConfigFileHandlerPowerTraining *filehandler;
	void buildGui();
	void setSignalsSlots();

	AddTestData *tab1Content;
	AddOtherData *tab2Content;
private slots:
	void reloadWidgets();
	void testDataPointAdded(int index);
signals:
	void dataPointAdded(int index); ///emits signal when datapoint was added to exercis with index 'index'
	
public slots:
	void rescale();
	void trainingsChanged();

 };
#endif
