//
// C++ Interface: AddExerciseDialog
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
/**
 * \class AddExerciseDialog
 *
 * \brief Provide an example
 *
 * This class is a QWidget, lets the user add exercises to the profile (from internet or not)
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */



#ifndef ADDEXERCISEDIALOG_H
#define ADDEXERCISEDIALOG_H
#include "ui_AddExerciseDialog.h"
#include "ConfigFileHandlerPowerTraining.h"
#include <QtGui/QMessageBox>
#include "qxtxmlrpcclient.h"
#include "OneExercise.h"

class AddExerciseDialog : public QWidget
 {
     Q_OBJECT

 public:
     	AddExerciseDialog(QWidget *parent = 0,ConfigFileHandlerPowerTraining *filehandler=0);
	void loadsettings(ConfigFileHandlerPowerTraining *filehandler);
 private:
     	Ui::AddExerciseDialog ui;
	ConfigFileHandlerPowerTraining *filehandler;
	
	void addToItemList(QString name);
	void addToMuscleList(QString name);
	QList<QListWidgetItem*> *itemList;
	QList<QListWidgetItem*> *muscleList;
	
	void fillComboBoxes();
	
	OneExercise *tab2Concent;
	QxtXmlRpcClient *myClient;	
private slots:
	void addExercise1(QString newname, QString newexplaination, QStringList newmuscles,QString tag); ///tab1
	void addExercise2(); ///tab2
	void search();	
	void fault(int callId, int faultCode, QString faultString);
	void parseError(int callId, QString errorMsg);
	void networkError(int callId, QString errorMsg);
	void finished1(int callId, QVariant retValue);
	void finished2(int callId, QVariant retValue);
	void finished3(int callId, QVariant retValue);
	
	void addTag(QString tag);
public slots:
	void itemWasClicked(QListWidgetItem*);

signals:
	void exerciseAdded();
	void exerciseTagListChanged();
	
};


#endif

