/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class AddOtherData
 *
 * \brief Provide an example
 *
 * This class is a QWidget which lets the user add datapoints to the profile
 * The datapoints are OtherDataPoints and not used in Plots, progress and suggestions
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef ADDOTHERDATA_H
#define ADDOTHERDATA_H
#include "ui_AddOtherData.h"
#include "ConfigFileHandlerPowerTraining.h"
#include "TrainingSchedule.h"
#include "SelectExerciseWidget.h"
#include "ScheduleOccurrence.h"
#include "ExerciseHandler.h"
#include "QStringDates.h"
#include <QtGui/QMessageBox>

class AddOtherData : public QWidget
 {
     Q_OBJECT

 public:
     	AddOtherData(QWidget *parent, ConfigFileHandlerPowerTraining *filehandler);
	void loadsettings(ConfigFileHandlerPowerTraining *filehandler);
	void insertDataForTraining(Training *training);
 private:
     	Ui::AddOtherData ui;
	ConfigFileHandlerPowerTraining *filehandler;
	void setSignalsSlots();
	void loadEnterScheduleWidget(QString scheduleName, QList<QString> selectedExercises);
	QBrush swapBrush(QBrush brush);

	bool training; //true when user is adding trainingdata
	bool schedule; //true when user is adding scheduledata
	bool busytabling;

	QList<Training*> trainingList; //when entering training data (all trainings from the past or today)
	int nbOfSchedulesInTraining; //when entering training data, 0 in case of no training selected
	int nbOfSchedulesAlreadyEntered;
	Training *pTraining; //training we are entering data of.
	///QString scheduleName; // when adding a schedule, we save the name of selected schedule

	bool overridingExistingScheduleOc(ScheduleOccurrence *scheduleOc);

	SelectExerciseWidget *selectExercises;
private slots:
	void nextPressed();
	void cancelPressed();
	void finishPressed();
public slots:
	void fillComboBoxes();
 };
#endif
