/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "AddTestData.h"
//   #include <stdio.h>
//   #include <iostream>
//  using namespace std;

AddTestData::AddTestData(QWidget *parent, ConfigFileHandlerPowerTraining *filehandler)
     : QWidget(parent)
 {
     	ui.setupUi(this);
	this->filehandler = filehandler;
// 	makeWidgets();
// 	setDefaultValues();
// 	setSignalsSlots();
///	ui.hboxLayout->setSizeConstraint(QLayout::SetMaximumSize);
	//this->setSizePolicy(QSizePolicy::Expanding);
///	ui.vboxLayout->setSizeConstraint(QLayout::SetMaximumSize);
	//this->setMinimumHeight(1000);
	//this->setMinimumHeight(1000);

// 	labellist =  new QList<QLabel*>();
// 	datelist = new QList<QDateEdit*>();
// 	weightlist = new QList<QSpinBox*>();
// 	repetitionlist = new QList<QSpinBox*>();
// 	buttonlist = new QList<QtrainerButton*>();

	labelmap =  new QMap<int,QLabel*>();
	datemap = new QMap<int,QDateEdit*>();
	weightmap = new QMap<int,QSpinBox*>();
	repetitionmap = new QMap<int,QSpinBox*>();
	buttonmap = new QMap<int,QtrainerButton*>();
}

/**
 * executed when an exercise gets added (this is a slot)
 */
void AddTestData::reloadWidgets()
{
removeWidgets();
makeWidgets();
setDefaultValues();
setSize();
}

/**
 * This method makes the widget large enough, so the scrollarea will scroll :-)
 */
void AddTestData::setSize()
{
this->setMinimumHeight(100);
this->resize(this->width(),100);
int height = filehandler->getExercise()->getNbOfExercises()*35+120;
this->setMinimumHeight(height+20);
/* this->setMinimumHeight(height);
 ui.hboxLayout->setSizeConstraint(QLayout::SetMaximumSize);
 ui.gridLayout->setSizeConstraint(QLayout::SetMaximumSize);*/
}

/**
* set the width, necessery because of the QScrollArea, slot
* Needs to be executed after selecting this widget from the left-bar
*/
void AddTestData::rescale()
{
this->resize(parentWidget()->size().width()-20,this->height());

}


/**
 * when loading a new profile we need to remove old widgets firsts
 */
void AddTestData::removeWidgets()
{
QList<int> ids = labelmap->keys();
for(int i=0;i<ids.size();i++){
	labelmap->value(i)->close();
	datemap->value(i)->close();
	weightmap->value(i)->close();
	repetitionmap->value(i)->close();
	buttonmap->value(i)->close();
	}
labelmap->clear();
datemap->clear();
weightmap->clear();
repetitionmap->clear();
buttonmap->clear();
}

/**
 * make all the widgets, indicated by exercise
 */
void AddTestData::makeWidgets()
{
	QList<Exercise*> exerciseList = filehandler->getExercise()->getExercises();
	for(int i =0; i<exerciseList.size();i++)
		{
		Exercise *ex = exerciseList.at(i);
		int index = ex->getIndex();
		labelmap->insert(index,new QLabel(this));
		datemap->insert(index,new QDateEdit(this));
		weightmap->insert(index,new QSpinBox(this));
		repetitionmap->insert(index,new QSpinBox(this));
		buttonmap->insert(index,new QtrainerButton(this));
		ui.gridLayout->addWidget(labelmap->value(index),i+1,0,1,1);
		ui.gridLayout->addWidget(datemap->value(index),i+1,1,1,1);
		ui.gridLayout->addWidget(weightmap->value(index),i+1,2,1,1);
		ui.gridLayout->addWidget(repetitionmap->value(index),i+1,3,1,1);
		ui.gridLayout->addWidget(buttonmap->value(index),i+1,4,1,1);
		datemap->value(index)->setCalendarPopup(true);
		labelmap->value(index)->setText(exerciseList.at(i)->getName());
		buttonmap->value(index)->setText(tr("Insert data"));
		QObject::connect(buttonmap->value(index),SIGNAL(pressedQtrainer(int)), this, SLOT(appenddata(int)));
		buttonmap->value(index)->setindex(index);
		weightmap->value(index)->setMaximum(999);
		repetitionmap->value(index)->setMaximum(999);
		}
	///cout <<"AddTestData: We made "<<lastrow+1<<" widgets"<<endl;
	//ui.gridLayout->addStretch(100);
}

/**
 * Sets all the widgets to default values
* Needs to be executed after adding data-points
 * @post (date widgets).getdate == today
 * @post (repetitions).get == default for the profile
 * @post (weight).get == last entered value
 */
void AddTestData::setDefaultValues()
{
int defaultrepetitions = filehandler->getExercise()->getDefaultValueForRepetitions();
QList<int> indexes = filehandler->getExercise()->getIndexes();
int maxvalue = indexes.size();
QDate currentDate = QDate::currentDate();
//filehandler->sortallexercises();

for(int i =0; i<maxvalue;i++)
	{
	int index = indexes.at(i);
 	datemap->value(index)->setDate(currentDate);
 	repetitionmap->value(index)->setValue(defaultrepetitions);
	int temp =  filehandler->getlatestweight(index);
 	weightmap->value(index)->setValue(temp);
	}
}


void AddTestData::loadsettings(ConfigFileHandlerPowerTraining *filehandler)
{
	this->filehandler=filehandler;
	removeWidgets();
 	makeWidgets();
 	setDefaultValues();
// 	setSize();
}

/**
 * adds a datapoints and increases the number of datapoints to be displayed with one!
*@param index the ID of the exercise
 */
void AddTestData::appenddata(int index)
{
QDate date = datemap->value(index)->date();
QString name = filehandler->getExercise()->getName(index);
	if(filehandler->isdatealreadystored(name,date))
	{
		QMessageBox msgBox;
		msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
		msgBox.setText(tr("You already entered data on this day.\n Should it be overwritten?"));
		msgBox.setDetailedText(tr("Qtrainer only lets you fill in one datapoint a day.\nEnter your 'best' datapoint, or the datapoint indicated by your schedule."));
 		switch (msgBox.exec()) 
			{
			case QMessageBox::Yes:
			filehandler->appenddata(name,weightmap->value(index)->value(),repetitionmap->value(index)->value(),date);
			emit dataPointAdded(index);
			break;
			case QMessageBox::No:
     			// no was clicked
			break;
 			default:
     			// should never be reached
     			break;
 			}
	}
	else
	{
	filehandler->appenddata(name, weightmap->value(index)->value(),repetitionmap->value(index)->value(),date);
	emit dataPointAdded(index);
	///We should plot one more point unless we have overwritten an existing value
	///commented out, because appenddata now automaticly increases the number of points to be plotted
	// 	int number = filehandler->getnumberofpointstoplot(name);
	// 	number++;
	// 	filehandler->savenumberofpointstoplot(name,number);
	}
}


