//
// C++ Interface: CalculateProgress
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
/**
 * \class CalculateProgress
 *
 * \brief Provide an example
 *
 * This class is a QThread. It was created because calculating the progress, can become slow 
 * in big profiles.
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef CALCULATEPROGRESS_H
#define CALCULATEPROGRESS_H


#include "ConfigFileHandlerPowerTraining.h"
#include <QtCore/QThread>
#include <QtCore/QMutex>


class CalculateProgress: public QThread
 {
	Q_OBJECT
	public:
	CalculateProgress(QObject *parent, ConfigFileHandlerPowerTraining* filehandler, int nbPoints, QMutex *mutex);
	private:
	ConfigFileHandlerPowerTraining *filehandler;
	int NumberOfPoints;
	
	QMutex *mutex;	
	QTime t;
	public:
	void setFileHandler(ConfigFileHandlerPowerTraining *filehandler);
	void setNbPoints(int nbPoints);
	void run();
	signals:
	void finished(QString newvalue, QString newnumber);
	void takingtoolong();
 };

#endif
