/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * \class ConfigFileHandlerPowerTraining
 *
 * \brief Provide an example
 *
 * This class takes care of the config files. More precisely it stores the profile information and
 * the data for PowerTraining Profiles
 *
 * \note In the future maybe XML will be used
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef CONFIGFILEHANDLERPOWERTRAINING_H
#define CONFIGFILEHANDLERPOWERTRAINING_H

#include "ExerciseHandler.h"
#include "Training.h"
#include "QStringDates.h"
#include "TrainingSchedule.h"
#include "ScheduleOccurrence.h"
#include "ConfigFileHandler.h"


class ConfigFileHandlerPowerTraining: public ConfigFileHandler
 {
     Q_OBJECT

///IMPORTANT NOTE FOR THE DEVELOPPER: we use a QMultiHash and no QHash because we store weights AND repetitions
public:
     	ConfigFileHandlerPowerTraining(QString profilename, ExerciseHandler *exercise=0, QObject *parent=0);
	//float normalize(float weightused,float repsdone, int nbReps);
// 	void addExerciseTag(QString tag);
	void addScheduleOccurrence(ScheduleOccurrence *scheduleOc);

	QList<ScheduleOccurrence>* getScheduleOccurrences(QString date); /// date == "dd.MM.yyyy"
	bool containsScheduleOccurrences(QString date);
	QMap<QString, QList<ScheduleOccurrence>* > *getScheduleOccurrenceList();
// 	QStringList getPossibleExerciseTagList();

	//QString getSport();
	void logout();

private:

	//QList<QMultiHash<QString, int>* > *hashesOfExercises;
	//QList<int> *pointsToPlotOfExercise;
	ExerciseHandler *exercise;

	//float NORMALIZE_FACTOR;

	//QList<QString> *listnames; ///name of the exercise, in the same order as listdates;
	//QList<QString> *listdates; 
	//QList<int> *listweights; ///same order as listdates
	//QList<int> *listrepetitions;///same order as listdates

	QMap<QString,TrainingSchedule*> *trainingScheduleList; ///title,schedule
	QMap<StringDate, Training*> *trainingList; ///date, training	
// 	QStringList *possibleExerciseTagList;
	QMap<QString, QList<ScheduleOccurrence>* > *scheduleOccurrenceList; ///date, scheduleOccses in a list
	
	void loaddata(QString profilename);
	void processline(QString line);
	void clearalldatahashes();

	//QVector<QPointF> getvector(QMultiHash<QString, int> *hash, int numberofpoints);
	// QVector<QPointF> cutnpoints(int n, QVector<QPointF> vector); 
	
	//void sortdatainQLists();
	
	//void removeFromOrderedLists(QMultiHash<QString, int> hash);
	//void sortdatainQLists(QMultiHash<QString, int> hash);

	void makeAllHashesAndLists();
	
	//float normalize(int repetitions, int weight);
	float getprogress(int numberoftrainings, QString exercisename);

public:
	//void sortallexercises();
	ExerciseHandler *getExercise();	

	int getnumberofpointstoplot(QString exercisename);
	int getlatestweight(QString exercisename);
	int getlatestweight(int index);

	//int defaultValueForRepetitions;
	void setprofilename(QString profilename);

	//QVector<QPointF> getvector(QString exercisename, int numberofpoints); ///points to plot
	QVector<QPointF> getvector(QString exercisename); ///points to plot
	//QList<QString> getdates(); ///old to new
	//QList<int> getweights(bool withsort=true);///old to new
	//QList<int> getrepetitions(bool withsort=true);///old to new
	//QList<QString> getnames(bool withsort=true);///old to new
	QList<Training*> getTrainings(); ///unordered
	QList<TrainingSchedule*> getTrainingSchedules(); ///unordered
	TrainingSchedule* getTrainingSchedule(QString name);

	//int getnumberofpoints(QString exercisename);
	//int getDefaultValueForRepetitions();
	float getprogress(int numberoftrainings);

	bool isdatealreadystored(QString exercisename, QDate date);

	void addQMultiHash();
	//void removeQMultiHash(int index);
	void addExercise(QString name, QString explaination, QStringList muscleList, QString tag=tr("No tag"));
	void saveExercise(QString newname, QString newexplaination,QStringList newMuscleList,QString newtag, int index);
	void deleteExercise(int index);
	void deleteTrainingSchedule(QString name);
	void planTraining(Training *training,bool withsaving=true);
	
	void addSchedule(TrainingSchedule *schedule);
public slots:
	void savedata(); ///Writes all to disk

	void savenumberofpointstoplot(QString exercisename, int number); //needed? just wraps around ExerciseHandler
		
	void appenddata(QString exercisename, int weight, int quantity, QDate data);
	
	void deleteTraining(QDate date); 

	void someTrainingScheduleChanged(QString oldName, TrainingSchedule *newschedule); 
// signals:
// 	void exerciseTagListChanged(QStringList newList);
// 	void exerciseTagListChanged();
 };


#endif // CONFIGFILEHANDLERPOWERTRAINING_H
