/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "Exercise.h"
// #include <stdio.h>
// #include <iostream>
// using namespace std;

Exercise::Exercise(int index, QString name,QString explanation,int nbPointsToPlot,QStringList plotMethodList, QStringList muscleList,QString tag, ExerciseHandler *parent) : QtrainerMeasurable(index, parent)
{
this->index = index;
this->muscleList =muscleList;
this->tag =tag;
this->exFileHandler=parent;
setName(name);
setExplanation(explanation);
setNbOfPointsToPlot(nbPointsToPlot);
setPlotMethod(plotMethodList);

}

/**
*Returns the default nb of repetitions, the one you can do using the normalised weight
*/
int Exercise::getDefaultValueForRepetitions(){
return exFileHandler->getDefaultValueForRepetitions();
}

/**
*Factor used for normalisation
*/
float Exercise::getNormaliseFactor(){
return exFileHandler->getNormaliseFactor();
}


/**
*Returns a list of all the measurements of this map.
*the measurements are ordered in ascneding order.
*/
QList<PowerTrainingMeasurement*> Exercise::getMeasurements(){
return measurementsMap.values();
}

/**
*Returns the number of datapoints(measurements) entered for this exercse
*/
int Exercise::getNbOfDatapoints(){
return measurementsMap.size();
}

/**
*Returns a QVector with the first points the most recent one. 
*The other points are ordered by the day they where entered.
*X-coordinate is the number of days ago the data was entered.
*Y-coordinate is the corresponding value
*/
QVector<QPointF> Exercise::getVector(){
QVector<QPointF> data;
for (int i=0;i<getMeasurements().size();i++){
	QDate dateOfMeasurement = getMeasurements().at(i)->getDate().getQDate();
	QPointF pointf;
	pointf.setX(dateOfMeasurement.daysTo(QDate::currentDate()));
	pointf.setY(getMeasurements().at(i)->getNormalisedWeight());
	data.prepend(pointf);	
	}
return data;
}

/**
*Unique ID which is assigned when Qtrainer loads the profile, or when the exercise is added to
*the profile
*/
int Exercise::getIndex(){
return index;
}

/**
*Returns the PowerTrainingMeasurement on date date
*Make sure the measurements exists! use hasMeasurment(StringDate)
*/
PowerTrainingMeasurement *Exercise::getMeasurement(StringDate date){
return measurementsMap.value(date);
}

/**
*returns true when this Exercise has a measurement on the given date
*/
bool Exercise::hasMeasurement(StringDate date){
return measurementsMap.contains(date);
}

/**
*Returns the picture
*/
QPixmap Exercise::getPicture(){
return this->pixmap;
}

/**
*Returns the muscles trained by this exercise
*/
QStringList Exercise::getMuscleList(){
return this->muscleList;
}

/**
*Returns the tag that comes with this exercise
*/
QString Exercise::getTag(){
return tag;
}

/**
*new.getTag() == tag
*/
void Exercise::setTag(QString tag){
this->tag=tag;
emit measurementChanged();
}

/**
*new.hasMeasurment(mes->getDate()))
*nb points to plot is increased by one
*if already a measurement exist with date mes->getDate() it is overridden
*/
void Exercise::linkMeasurement(PowerTrainingMeasurement *mes){
bool increase=true;
if(measurementsMap.contains(mes->getDate())){
///we are overriding a measurement
increase = false;
}
measurementsMap.insert(mes->getDate(),mes);
if(increase){
	setNbOfPointsToPlot(getNbOfPointsToPlot()+1);
	}
emit measurementChanged();
}

/**
*new.getPicture() = pic
*/
void Exercise::setPicture(QPixmap pic){
this->pixmap = pic;
emit measurementChanged();
}

/**
*new.getMuscleList() = list
*/
void Exercise::setMuscleList(QStringList list){
this->muscleList = list;
emit measurementChanged();
}

/**
*String version of the exercise
*/
QString Exercise::toString(){
QString name = getName();
name.append("!");
name.append(getExplanation());
name.append("!tag=");
name.append(getTag());
for(int j=0;j<getMuscleList().size();j++){
	name.append("!");
	name.append(getMuscleList().at(j));
}
name.append("!\n");
return name;
}
	
