/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * \class Exercise
 *
 * \brief Provide an example
 *
 * This class is an Exercise which contains a list of its PowerTrainingMeasurements
 * An exercise has a unique ID (=index), muscleList, tag, picture, PlotMethod, nbPointsToPlot
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef EXERCISE_H
#define EXERCISE_H

#include <QtCore/QList>
#include <QtGui/QPixmap>
#include <QWidget>
#include <QObject>
#include "PowerTrainingMeasurement.h"
#include "QStringDates.h"
#include "QtrainerMeasurable.h"
#include <QMap>
#include "ExerciseHandler.h"
//  #include <QTextStream>

class ExerciseHandler;

class Exercise: public QtrainerMeasurable
 {
     Q_OBJECT
public:
	Exercise(int index, QString name,QString explanation,int nbPointsToPlot,QStringList plotMethodList, QStringList muscleList,QString tag, ExerciseHandler *parent = 0);
	
	QList<PowerTrainingMeasurement*> getMeasurements();
	PowerTrainingMeasurement *getMeasurement(StringDate date);
	QPixmap getPicture();
	QStringList getMuscleList();
	QString getTag();

	bool hasMeasurement(StringDate date);

	void setTag(QString tag);
	void linkMeasurement(PowerTrainingMeasurement *mes);
	void setPicture(QPixmap pic);
	void setMuscleList(QStringList list);

	QVector<QPointF> getVector();	
	
	QString toString();

	float getNormaliseFactor();
	int getDefaultValueForRepetitions();
	int getNbOfDatapoints();

private:
	QMap<StringDate, PowerTrainingMeasurement*> measurementsMap;
	QPixmap pixmap;
	QStringList muscleList;
	QString tag;
	ExerciseHandler *exFileHandler;
	int index;
public:
	int getIndex(); //unique ID, which is assigned when Qtrainer loads the profile
	
};

#endif //EXERCISE_H
