/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * \class ExerciseHandler
 *
 * \brief Provide an example
 *
 * This class takes care of the config files. More precisely it stores the profile information and
 * the data.
 *
 * \note In the future maybe XML will be used
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef EXERCISEHANDLER_H
#define EXERCISEHANDLER_H

#include <QApplication>
#include <QtCore/QSettings>
#include <QtGui/QWidget>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QList>
#include <QtGui/QPixmap>
#include <QtCore/QFile>
#include "Exercise.h"
//  #include <QTextStream>

class ExerciseHandler: public QObject
 {
     Q_OBJECT
public:
	ExerciseHandler(QObject *parent = 0);

	int getDefaultValueForRepetitions();
	float getNormaliseFactor();

	QStringList getPossibleExerciseTagList();
	void setPossibleExerciseTagList(QStringList list);
	void addExerciseTag(QString tag);

	QList<int> getIndexes(); //returns a list containing all the ID's of all the exercises
private:
	/**
	*QMaps storing the exercises, one with fast lookup by index, and one with 
	*fast lookup by name, the two map ALWAYS contain the exact same exercises.
	*/
	QMap<QString, Exercise*> exerciseNameMap; //name,exercise
	QMap<int, Exercise*> exerciseIndexMap; //index,exercise


	QStringList possibleExerciseTagList;
	static QList<QString> possibleMusclesList; ///muscles of men
	void fillPossibleMusclesList();
	
	

	float NORMALIZE_FACTOR;
	int defaultValueForRepetitions;




	/*static QList<QString> nameList;
	static QList<QStringList> plotMethodList;
	static QList<QString> explainationList;
	static QList<QPixmap> pictureList;
	
	static QList<QStringList> muscleList; ///muscles indexed by exercise
	static QList<QString> tagList;
	
	
	*///static int NumberOfHardCodedExercises;

public:
	int getNbOfExercises();
	QString getName(int index);
	QString getExplanation(int index);
	Exercise *getExercise(int index);
	Exercise *getExercise(QString name);
	QList<Exercise*> getExercises();

// 	QList<QStringList> getPlotMethodList();
// 	QList<QString> getNameList();
// 	QList<QString> getExplainationList();
// 	QList<QPixmap> getPictureList();
// 	QList<QStringList> getMuscleList();
// 	QList<QString> getTagList();
	QList<QString> getPossibleMuscleList();
	int getindex(QString exercisename);
	void addExercise(QString name, QString explaination, QStringList musclelist,QString tag=tr("No tag"));
	//int getHardCoded();
	bool isAlreadyStored(QString name);
	bool contains(int index);
	void clear();
	
	void setPlotMethod(QStringList newplotmethods, int index);
	void replaceName(QString newname, int index);
	void replaceExplaination(QString newexplaination, int index);
	void replaceMuscle(QStringList newMuscleList, int index);
	void replaceTag(QString newtag, int index);
	void deleteExercise(int index);

signals:
	void exerciseTagListChanged(QStringList newList);
	void exerciseTagListChanged();
	void saveDataRequest(); /// something changed to the profile, request saving to disk
private slots:
	void someMeasurementChanged();
};

#endif //EXERCISEHANDLER_H
