/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class Grid
 *
 * \brief 
 *
 * This class is a QWidget. 
 * It displays the scheduleOccurences in a grid/table,
 * and also the test-data-points in a table
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef GRID_H
#define GRID_H
#include "ui_Grid.h"
#include "ConfigFileHandlerPowerTraining.h"
#include "ScheduleOccurrence.h"
#include "QStringDates.h"
#include "TableWidget.h"
#include <QtGui/QPrintDialog>
#include <QtGui/QPrinter>
#include <QtGui/QPixmap>
#include <QtCore/QRect>
#include <QtCore/QSize>
#include <QtGui/QPainter>
#include <QtGui/QPaintEvent>

class Grid : public QWidget
 {
     Q_OBJECT

 public:
     	Grid(QWidget *parent, ConfigFileHandlerPowerTraining *filehandler);
	void loadsettings(ConfigFileHandlerPowerTraining *filehandler);
 private:
     	Ui::Grid ui;
	ConfigFileHandlerPowerTraining *filehandler;
	TableWidgetOfTestData *tab1Content;
	QList<ScheduleOccurrence> selectedScheduleOccurrenceList;	

	void buildGui();
	void updateSelectedScheduleOcList();

	bool busytabling;
private slots:
	void scheduleChanged(QString newschedule);
	void dateChanged(QDate newdate);
	void currentScheduleOcChanged(int);
	void cellChanged(int row ,int collumn);

	void printScheduleOccurrence();

	void someValueChanged();
public slots:
	void reloadOtherScheduleOccurrences();
	void redraw();
	void redraw(int i);
signals:
	void updateVisualisation();
	
 };
#endif
