//
// C++ Interface: InformationWidget
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class InformationWidget
 *
 * \brief 
 *
 * This class is a QWidget Which only contains GUI stuff and methods to control the gui for the information widget
* of the powertraining profile
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef INFORMATIONWIDGET_H
#define INFORMATIONWIDGET_H
#include "ui_InformationWidget.h"

class InformationWidget : public QWidget
 {
     Q_OBJECT

 public:
     	InformationWidget(QWidget *parent);
	void setProgressLabel(QString text);
	void setLabelForum(QString text);
	void setNextTrainingLabel(QString text);
	void setProfileLabel(QString text);

	void setVisibleProgressLabel(bool var);
	void setVisibleNextTrainingLabel(bool var);
	void setVisibleLabelForum(bool var);
	void setVisibleProfileLabel(bool var);

	void setVisibleShowTrainingButton(bool var);
	void setVisibleAddTestDataButton(bool var);
	void setVisibleAddLatestScheduleButton(bool var);
	void setVisibleShowTestScheduleButton(bool var);
	void setShowTrainingButton(QString text);
	void setAddTestDataButton(QString text);
	void setAddLatestScheduleButton(QString text);
	void setShowTestScheduleButton(QString text);

	void setVisibleShowTestScheduleLabel(bool var);
	void setShowTestScheduleLabel(QString text);

	QPushButton *getShowTrainingButton();
	QPushButton *getAddTestDataButton();
	QPushButton *getAddLatestScheduleButton();
	QPushButton *getShowTestScheduleButton();

 private:
     	Ui::InformationWidget ui;

 };
#endif
