/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class OneExercise
 *
 * \brief Provide an example
 *
 * This class is a QWidget. It shows one exercise that can be editted.
 *
 * MuscleList is all the legal muscles to choose from
 *
* By default the Widget is for modifiing existing exercises, adding newones can be done by setting forNewExercise tot true
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef ONEEXERCISE_H
#define ONEEXERCISE_H

#include "ui_OneExercise.h"
#include <QApplication>
#include <QtGui/QWidget>
#include <QtCore/QList>
#include "qxtxmlrpcclient.h"
#include "StringCheck.h"
#include <QtCore/QVariant>
#include <QtGui/QMessageBox>
#include <QtCore/QSettings>
#include <QtGui/QInputDialog>

class OneExercise : public QWidget
 {
     Q_OBJECT

public:
     	OneExercise(QWidget *parent = 0, int index=0, QList<QString> muscleList=QList<QString>(), QStringList taglist=QStringList());
	void setTitle(QString title);
	void setExerciseExplaination(QString str);
	void setExerciseName(QString name);
	void setTag(QString tag);
	bool addMuscle(QString muscle);
	bool addMuscles(QStringList muscles);
	void removeMuscle(QString muscle);
	void setNewExercise(bool var);
	void setAutoSaveFunctionOn();

	QString tag;
private:
	bool newExerciseMode;
     	Ui::OneExercise ui;
	int index;
	void fillComboBox();
	QList<QString> muscleList; ///All legal muscles to choose from
	QStringList tagList; ///All legal tags to choose from
	QxtXmlRpcClient *myClient;
private slots:
	void deleteExercise();
	void uploadExercise();	
	void fault(int callId, int faultCode, QString faultString);
	void parseError(int callId, QString errorMsg);
	void networkError(int callId, QString errorMsg);
	void finished(int callId, QVariant retValue);
	void removeMuscleButtonPressed();
	void addMuscleButtonPressed();
	void addTag();
	void currentTagChanged(int);
	void currentNameChanged(QString newName);

	void closeParent();
public slots:
	void save();
	void reloadTagList(QStringList tags);
	
signals:
	void saveExercise(QString newname, QString newexplaination, QStringList newmuscles,QString newtag);
	void saveExercise(QString newname, QString newexplaination, QStringList newmuscles,QString newtag, int index);
	void deleteExercise(int index);
	void addTag(QString text);
	void closeParent2();
 };

#endif
