//
// C++ Implementation: PlanTraining
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "PlanTraining.h"
//  #include <stdio.h>
//  #include <iostream>
//  using namespace std;

PlanTraining::PlanTraining(QWidget *parent,QDate date, ConfigFileHandlerPowerTraining *filehandler)
     : QWidget(parent)
 {
	selectedExercises = QMap<QString, QStringList>();

	this->filehandler = filehandler;
	this->traininglist = QList<TrainingSchedule*>(filehandler->getTrainingSchedules());
        ui.setupUi(this);
	QDate myDate=date;
	setValuesOfDates(myDate);
	fillComboBox();
	QObject::connect(ui.pushButton_2,SIGNAL(clicked()),this,SLOT(planTraining()));
	QObject::connect(ui.addScheduleButton,SIGNAL(clicked()),this,SLOT(addSchedule()));
	QObject::connect(ui.removeScheduleButton,SIGNAL(clicked()),this,SLOT(removeSchedule()));
	QObject::connect(ui.editScheduleButton,SIGNAL(clicked()),this,SLOT(editSchedule()));
	QObject::connect(ui.moveUpButton,SIGNAL(clicked()),this,SLOT(moveUpSchedule()));
	QObject::connect(ui.moveDownButton,SIGNAL(clicked()),this,SLOT(moveDownSchedule()));
 }


/**
*Move the selected training up one position in the list
*/
void PlanTraining::moveUpSchedule(){
if(ui.listWidget->currentRow() != -1 && ui.listWidget->currentRow() != 0){
	QList<QString> list = QList<QString>();
	for(int i=0;i<ui.listWidget->count();i++){
		list << ui.listWidget->item(i)->text();
		}
	list.swap(ui.listWidget->currentRow(),ui.listWidget->currentRow()-1);
	ui.listWidget->clear();
	for(int i=0;i<list.size();i++){
		ui.listWidget->addItem(list.at(i));
		}
	}
}

/**
*Move the selected training down one position in the list
*/
void PlanTraining::moveDownSchedule(){
if(ui.listWidget->currentRow() != -1 && ui.listWidget->currentRow() != ui.listWidget->count()-1){
	QList<QString> list = QList<QString>();
	for(int i=0;i<ui.listWidget->count();i++){
		list << ui.listWidget->item(i)->text();
		}
	list.swap(ui.listWidget->currentRow(),ui.listWidget->currentRow()+1);
	ui.listWidget->clear();
	for(int i=0;i<list.size();i++){
		ui.listWidget->addItem(list.at(i));
		}
	}
}

/**
*Alter the Selected exercise list for this schedule.
*\note the param schedulename is the name of the schedule, not the training
*/
void PlanTraining::editSchedule(QString schedulename){
SelectExerciseWidget *selectExerciseWidget = new SelectExerciseWidget(0,schedulename,filehandler, false);
selectExerciseWidget->setWindowFlags(Qt::SubWindow);
QObject::connect(selectExerciseWidget, SIGNAL(saveSchedule(QStringList,QString)),this, SLOT(saveSchedule(QStringList,QString)));
selectExerciseWidget->addByName(selectedExercises.value(schedulename));
selectExerciseWidget->show();
}

/**
*This SLOT saves the selected exercises of the given schedule with 'schedulename' into this Training.
*/
void PlanTraining::saveSchedule(QStringList list, QString schedulename){
selectedExercises.insert(schedulename,list);
}

/**
*Alter the Selected exercise list for this schedule.
*/
void PlanTraining::editSchedule(){
if(ui.listWidget->currentRow() != -1){
	editSchedule(ui.listWidget->currentItem()->text());
	}
}


/**
*Add the selected trainingschedule to the list
*/
void PlanTraining::addSchedule(){
if(ui.comboBox->currentIndex() != -1){
	QString text= ui.comboBox->currentText();
	ui.listWidget->addItem(text);
	editSchedule(text);
	}
}


/**
*Remove the selected trainingschedule from the list
*/
void PlanTraining::removeSchedule(){
if(ui.listWidget->currentRow() != -1){
	selectedExercises.remove(ui.listWidget->currentItem()->text());
	ui.listWidget->takeItem(ui.listWidget->currentRow());
	}
}

/**
*Fill combobox trainingsschedules
*/
void PlanTraining::fillComboBox(){
QStringList list = QStringList();
for(int i=0;i<traininglist.size();i++){
if(!list.contains(traininglist.at(i)->getName())){
	list<<traininglist.at(i)->getName();
	}
}
ui.comboBox->clear();
ui.comboBox->addItems(list);
}

/**
*makes GUI reflect the date settings
*/
void PlanTraining::setValuesOfDates(QDate date){
	ui.dateEdit->setDate(date);
	ui.dateEdit_2->setDate(date);
	QTime time = QTime(QTime::currentTime().hour()+1, 0);
	ui.timeEdit->setTime(time);
	ui.timeEdit_2->setTime(time.addSecs(3600));
	int dayOfWeek=date.dayOfWeek();
	if(dayOfWeek==1){ui.checkBox_mo->setCheckState(Qt::Checked);}
	if(dayOfWeek==2){ui.checkBox_tue->setCheckState(Qt::Checked);}
	if(dayOfWeek==3){ui.checkBox_we->setCheckState(Qt::Checked);}
	if(dayOfWeek==4){ui.checkBox_thu->setCheckState(Qt::Checked);}
	if(dayOfWeek==5){ui.checkBox_fr->setCheckState(Qt::Checked);}
	if(dayOfWeek==6){ui.checkBox_sa->setCheckState(Qt::Checked);}
	if(dayOfWeek==7){ui.checkBox_su->setCheckState(Qt::Checked);}
}

/**
*Plan a training on every selected day.
*/
void PlanTraining::planTraining(){
///check data
bool nameOK = StringCheck::check(ui.lineEdit->text(),false,tr("The name you entered has illegal\n characters in it or is empty."));
bool explanationOK = StringCheck::check(ui.textEdit->toPlainText(),true,tr("The explanation you entered has illegal characters in it."));
if(explanationOK && nameOK){

	///fetch data
	QDate start=ui.dateEdit->date();
	QDate end=ui.dateEdit_2->date();
	if(start.daysTo(end)<0){end=start;} //end<start
	QDate iteratorDate = start;
	bool withsave=true;
	QList<QString> orderList = QList<QString>();
	for(int i=0;i<ui.listWidget->count();i++){
	orderList.append(ui.listWidget->item(i)->text());
	}
	while(end>=iteratorDate){
		if(legalDay(iteratorDate) || iteratorDate == start){
			QString explanation = ui.textEdit->toPlainText();
			explanation.replace(QString("\n"), "  ");
			//QStringList scheduleList = QStringList();
			//for(int i=0;i<ui.listWidget->count();i++){
			//	scheduleList<<ui.listWidget->item(i)->text();
			//	}

			///plan training
			Training *myTraining = new Training(selectedExercises, orderList, iteratorDate,ui.timeEdit->time(),ui.timeEdit_2->time(),ui.lineEdit->text(),explanation);
			emit planTraining(myTraining, withsave);
			}
		iteratorDate=iteratorDate.addDays(1);
		}



	///tel the user the exercise was added
// 	QMessageBox msgBox;
// 	msgBox.setStandardButtons(QMessageBox::Ok);
// 	msgBox.setText(tr("The Training has been planned."));
// 	msgBox.exec();
	close();
}

}


/**
*is it a legal date. This doesn't check if it is between start and enddate, but only of the day of the week
*is a legal one (selected one)
*/
bool PlanTraining::legalDay(QDate date){
bool result=false;
if(date.dayOfWeek()==1 && ui.checkBox_mo->isChecked()){result=true;}
if(date.dayOfWeek()==2 && ui.checkBox_tue->isChecked()){result=true;}
if(date.dayOfWeek()==3 && ui.checkBox_we->isChecked()){result=true;}
if(date.dayOfWeek()==4 && ui.checkBox_thu->isChecked()){result=true;}
if(date.dayOfWeek()==5 && ui.checkBox_fr->isChecked()){result=true;}
if(date.dayOfWeek()==6 && ui.checkBox_sa->isChecked()){result=true;}
if(date.dayOfWeek()==7 && ui.checkBox_su->isChecked()){result=true;}
return result;
}



